/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.field;

import io.debezium.annotation.Immutable;
import io.debezium.connector.jdbc.type.JdbcType;
import io.debezium.sink.column.ColumnDescriptor;
import io.debezium.sink.field.FieldDescriptor;
import io.debezium.sink.valuebinding.ValueBindDescriptor;
import java.util.List;

@Immutable
public class JdbcFieldDescriptor
extends FieldDescriptor {
    private final JdbcType jdbcType;
    private String queryBinding;

    public JdbcFieldDescriptor(FieldDescriptor fieldDescriptor, JdbcType type, boolean isKey) {
        super(fieldDescriptor.getSchema(), fieldDescriptor.getName(), isKey);
        this.jdbcType = type;
    }

    public String getQueryBinding(ColumnDescriptor column, Object value) {
        if (this.queryBinding == null) {
            this.queryBinding = this.jdbcType.getQueryBinding(column, this.schema, value);
        }
        return this.queryBinding;
    }

    public List<ValueBindDescriptor> bind(int startIndex, Object value) {
        return this.jdbcType.bind(startIndex, this.schema, value);
    }

    public String toString() {
        return "JdbcFieldDescriptor{schema=" + String.valueOf(this.schema) + ", name='" + this.name + "', isKey='" + this.isKey + "', typeName='" + this.jdbcType.getTypeName(this.schema, this.isKey) + "', jdbcType=" + String.valueOf(this.jdbcType) + ", columnName='" + this.columnName + "'}";
    }
}

