/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.relational;

import io.debezium.DebeziumException;
import io.debezium.annotation.Immutable;
import io.debezium.metadata.CollectionId;
import io.debezium.sink.column.ColumnDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Immutable
public class TableDescriptor {
    private final CollectionId id;
    private final String tableType;
    private final Map<String, ColumnDescriptor> columns = new LinkedHashMap<String, ColumnDescriptor>();
    private final List<String> primaryKeyColumnNames;
    private final boolean autoGeneratedIdentityColumn;

    private TableDescriptor(CollectionId id, String tableType, List<ColumnDescriptor> columns, List<String> primaryKeyColumnNames) {
        this.id = id;
        this.tableType = tableType;
        this.primaryKeyColumnNames = primaryKeyColumnNames;
        columns.forEach(c -> this.columns.put(c.getColumnName(), (ColumnDescriptor)c));
        this.autoGeneratedIdentityColumn = columns.stream().findFirst().filter(ColumnDescriptor::isAutoIncrement).isPresent();
    }

    public static Builder builder() {
        return new Builder();
    }

    public CollectionId getId() {
        return this.id;
    }

    public String getTableType() {
        return this.tableType;
    }

    public Collection<ColumnDescriptor> getColumns() {
        return this.columns.values();
    }

    public ColumnDescriptor getColumnByName(String columnName) {
        ColumnDescriptor column = this.columns.get(columnName);
        if (column == null) {
            throw new DebeziumException(String.format("Failed to find column '%s' in table '%s'. If you have not enabled '%s', this could be related to column/field case differences.", columnName, this.id.name(), "quote.identifiers"));
        }
        return column;
    }

    public boolean hasColumn(String columnName) {
        return this.columns.containsKey(columnName);
    }

    public List<String> getPrimaryKeyColumnNames() {
        return this.primaryKeyColumnNames;
    }

    public Collection<ColumnDescriptor> getPrimaryKeyColumns() {
        return this.columns.values().stream().filter(c -> this.primaryKeyColumnNames.contains(c.getColumnName())).collect(Collectors.toList());
    }

    public boolean hasAutoGeneratedIdentityColumn() {
        return this.autoGeneratedIdentityColumn;
    }

    public static class Builder {
        private String catalogName;
        private String schemaName;
        private String tableName;
        private String tableType;
        private final List<ColumnDescriptor> columns = new ArrayList<ColumnDescriptor>();
        private final List<String> primaryKeyColumnNames = new ArrayList<String>();

        private Builder() {
        }

        public Builder catalogName(String catalogName) {
            this.catalogName = catalogName;
            return this;
        }

        public Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public Builder type(String tableType) {
            this.tableType = tableType;
            return this;
        }

        public Builder column(ColumnDescriptor column) {
            this.columns.add(column);
            return this;
        }

        public Builder columns(List<ColumnDescriptor> columns) {
            this.columns.addAll(columns);
            return this;
        }

        public Builder keyColumn(ColumnDescriptor column) {
            return this.keyColumn(column.getColumnName());
        }

        public Builder keyColumn(String columnName) {
            this.primaryKeyColumnNames.add(columnName);
            return this;
        }

        public TableDescriptor build() {
            CollectionId id = new CollectionId(this.catalogName, this.schemaName, this.tableName);
            return new TableDescriptor(id, this.tableType, this.columns, this.primaryKeyColumnNames);
        }
    }
}

