/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.transforms;

import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.jdbc.Module;
import io.debezium.connector.jdbc.util.NamingStyle;
import io.debezium.connector.jdbc.util.NamingStyleUtils;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.components.Versioned;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.transforms.Transformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionNameTransformation<R extends ConnectRecord<R>>
implements Transformation<R>,
Versioned {
    private static final Logger LOGGER = LoggerFactory.getLogger(CollectionNameTransformation.class);
    private static final Field PREFIX = Field.create((String)"collection.naming.prefix").withDisplayName("Collection Name Prefix").withType(ConfigDef.Type.STRING).withDefault("").withImportance(ConfigDef.Importance.LOW).withDescription("Optional prefix to add to collection names.");
    private static final Field SUFFIX = Field.create((String)"collection.naming.suffix").withDisplayName("Collection Name Suffix").withType(ConfigDef.Type.STRING).withDefault("").withImportance(ConfigDef.Importance.LOW).withDescription("Optional suffix to add to collection names.");
    private static final Field NAMING_STYLE = Field.create((String)"collection.naming.style").withDisplayName("Collection Naming Style").withType(ConfigDef.Type.STRING).withDefault("default").withImportance(ConfigDef.Importance.LOW).withDescription("The style of collection naming: UPPER_CASE, lower_case, snake_case, camelCase, kebab-case.");
    private String prefix;
    private String suffix;
    private NamingStyle namingStyle;

    public void configure(Map<String, ?> configs) {
        Configuration config = Configuration.from(configs);
        this.prefix = config.getString(PREFIX);
        this.suffix = config.getString(SUFFIX);
        this.namingStyle = NamingStyle.from(config.getString(NAMING_STYLE));
        LOGGER.info("Configured with prefix='{}', suffix='{}', naming style='{}'", new Object[]{this.prefix, this.suffix, this.namingStyle.getValue()});
    }

    public R apply(R record) {
        if (record.topic() == null) {
            LOGGER.debug("Record has null topic, skipping transformation");
            return record;
        }
        String originalTopic = record.topic();
        String transformedTopic = this.transformTopicName(originalTopic);
        LOGGER.debug("Transformed topic '{}' to '{}'", (Object)originalTopic, (Object)transformedTopic);
        return (R)record.newRecord(transformedTopic, record.kafkaPartition(), record.keySchema(), record.key(), record.valueSchema(), record.value(), record.timestamp());
    }

    private String transformTopicName(String originalTopic) {
        Object transformedName = NamingStyleUtils.applyNamingStyle(originalTopic, this.namingStyle);
        transformedName = this.prefix + (String)transformedName + this.suffix;
        return transformedName;
    }

    public ConfigDef config() {
        return new ConfigDef().define(PREFIX.name(), ConfigDef.Type.STRING, PREFIX.defaultValue(), ConfigDef.Importance.LOW, PREFIX.description()).define(SUFFIX.name(), ConfigDef.Type.STRING, SUFFIX.defaultValue(), ConfigDef.Importance.LOW, SUFFIX.description()).define(NAMING_STYLE.name(), ConfigDef.Type.STRING, NAMING_STYLE.defaultValue(), ConfigDef.Importance.LOW, NAMING_STYLE.description());
    }

    public void close() {
    }

    public String version() {
        return Module.version();
    }
}

