/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.transforms;

import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.jdbc.Module;
import io.debezium.connector.jdbc.util.NamingStyle;
import io.debezium.connector.jdbc.util.NamingStyleUtils;
import io.debezium.transforms.SmtManager;
import io.debezium.util.Strings;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.components.Versioned;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.transforms.Transformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldNameTransformation<R extends ConnectRecord<R>>
implements Transformation<R>,
Versioned {
    private static final Logger LOGGER = LoggerFactory.getLogger(FieldNameTransformation.class);
    private static final String COLUMN_PREFIX_PARAM = "column.naming.prefix";
    private static final String COLUMN_SUFFIX_PARAM = "column.naming.suffix";
    private static final String COLUMN_STYLE_PARAM = "column.naming.style";
    private static final Field PREFIX = Field.create((String)"column.naming.prefix").withDisplayName("Column Name Prefix").withType(ConfigDef.Type.STRING).withDefault("").withImportance(ConfigDef.Importance.LOW).withDescription("Optional prefix to add to column names.");
    private static final Field SUFFIX = Field.create((String)"column.naming.suffix").withDisplayName("Column Name Suffix").withType(ConfigDef.Type.STRING).withDefault("").withImportance(ConfigDef.Importance.LOW).withDescription("Optional suffix to add to column names.");
    private static final Field NAMING_STYLE = Field.create((String)"column.naming.style").withDisplayName("Column Naming Style").withType(ConfigDef.Type.STRING).withDefault("default").withImportance(ConfigDef.Importance.LOW).withDescription("The style of column naming: UPPERCASE, lowercase, snake_case, camelCase, kebab-case.");
    private String prefix;
    private String suffix;
    private NamingStyle namingStyle;
    private SmtManager<R> smtManager;

    public void configure(Map<String, ?> configs) {
        Configuration config = Configuration.from(configs);
        this.prefix = config.getString(PREFIX);
        this.suffix = config.getString(SUFFIX);
        this.namingStyle = NamingStyle.from(config.getString(NAMING_STYLE));
        this.smtManager = new SmtManager(config);
        LOGGER.info("Configured with prefix='{}', suffix='{}', naming style='{}'", new Object[]{this.prefix, this.suffix, this.namingStyle.getValue()});
    }

    public R apply(R record) {
        if (record.value() == null) {
            LOGGER.debug("Skipping null record value");
            return record;
        }
        Object object = record.value();
        if (!(object instanceof Struct)) {
            LOGGER.debug("Skipping non-Struct record value of type: {}", (Object)record.value().getClass().getName());
            return record;
        }
        Struct originalValue = (Struct)object;
        Schema originalSchema = record.valueSchema();
        if (originalSchema == null) {
            LOGGER.debug("Skipping record with null schema");
            return record;
        }
        try {
            TransformedSchemaValue newKey = this.transformKey(record);
            TransformedSchemaValue newValue = this.transformValue(record);
            return (R)record.newRecord(record.topic(), record.kafkaPartition(), newKey.schema(), newKey.value(), newValue.schema(), newValue.value(), record.timestamp());
        }
        catch (Exception e) {
            LOGGER.error("Error transforming field names: {}", (Object)e.getMessage(), (Object)e);
            throw e;
        }
    }

    private TransformedSchemaValue transformKey(R record) {
        Schema originalKeySchema = record.keySchema();
        if (originalKeySchema != null && originalKeySchema.type() == Schema.Type.STRUCT) {
            return this.transform(originalKeySchema, (Struct)record.key());
        }
        return new TransformedSchemaValue(originalKeySchema, record.key());
    }

    private TransformedSchemaValue transformValue(R record) {
        Schema originalSchema = record.valueSchema();
        if (originalSchema != null && originalSchema.type() == Schema.Type.STRUCT) {
            Struct originalValue = (Struct)record.value();
            if (this.isDebeziumPayloadSchema(originalSchema)) {
                SchemaBuilder schema = SchemaBuilder.struct();
                this.copySchemaProperties(originalSchema, schema);
                HashMap<String, Object> newValues = new HashMap<String, Object>();
                for (org.apache.kafka.connect.data.Field field : originalSchema.fields()) {
                    if (field.name().equals("before") || field.name().equals("after")) {
                        TransformedSchemaValue transformed = this.transform(field.schema(), (Struct)originalValue.get(field));
                        schema.field(field.name(), transformed.schema());
                        newValues.put(field.name(), transformed.value());
                        continue;
                    }
                    schema.field(field.name(), field.schema());
                    newValues.put(field.name(), originalValue.get(field));
                }
                Struct struct = new Struct(schema.build());
                newValues.forEach((k, v) -> {
                    if (v != null) {
                        struct.put(k, v);
                    }
                });
                return new TransformedSchemaValue(struct.schema(), struct);
            }
            return this.transform(originalSchema, originalValue);
        }
        return new TransformedSchemaValue(originalSchema, record.value());
    }

    private TransformedSchemaValue transform(Schema originalSchema, Struct originalValue) {
        if (originalValue == null) {
            return new TransformedSchemaValue(originalSchema, originalValue);
        }
        SchemaBuilder schema = SchemaBuilder.struct();
        this.copySchemaProperties(originalSchema, schema);
        originalSchema.fields().forEach(field -> schema.field(this.transformFieldName(field.name()), (Schema)this.copySchema(field.schema())));
        Struct value = new Struct(schema.build());
        originalSchema.fields().forEach(field -> value.put(this.transformFieldName(field.name()), originalValue.get(field)));
        return new TransformedSchemaValue(value.schema(), value);
    }

    private boolean isDebeziumPayloadSchema(Schema schema) {
        return !Strings.isNullOrEmpty((String)schema.name()) && schema.name().endsWith(".Envelope");
    }

    private void copySchemaProperties(Schema source, SchemaBuilder target) {
        if (source.name() != null) {
            target.name(source.name());
        }
        if (source.version() != null) {
            target.version(source.version());
        }
        if (source.doc() != null) {
            target.doc(source.doc());
        }
    }

    private SchemaBuilder copySchema(Schema schema) {
        SchemaBuilder builder;
        switch (schema.type()) {
            case BOOLEAN: {
                builder = SchemaBuilder.bool();
                break;
            }
            case INT8: {
                builder = SchemaBuilder.int8();
                break;
            }
            case INT16: {
                builder = SchemaBuilder.int16();
                break;
            }
            case INT32: {
                builder = SchemaBuilder.int32();
                break;
            }
            case INT64: {
                builder = SchemaBuilder.int64();
                break;
            }
            case FLOAT32: {
                builder = SchemaBuilder.float32();
                break;
            }
            case FLOAT64: {
                builder = SchemaBuilder.float64();
                break;
            }
            case STRING: {
                builder = SchemaBuilder.string();
                break;
            }
            case BYTES: {
                builder = SchemaBuilder.bytes();
                break;
            }
            case ARRAY: {
                builder = SchemaBuilder.array((Schema)schema.valueSchema());
                break;
            }
            case MAP: {
                builder = SchemaBuilder.map((Schema)schema.keySchema(), (Schema)schema.valueSchema());
                break;
            }
            case STRUCT: {
                builder = SchemaBuilder.struct();
                for (org.apache.kafka.connect.data.Field field : schema.fields()) {
                    builder.field(field.name(), field.schema());
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported schema type: " + String.valueOf(schema.type()));
            }
        }
        if (schema.isOptional()) {
            builder.optional();
        }
        if (schema.defaultValue() != null) {
            builder.defaultValue(schema.defaultValue());
        }
        this.copySchemaProperties(schema, builder);
        return builder;
    }

    private String transformFieldName(String originalName) {
        String transformedName = NamingStyleUtils.applyNamingStyle(originalName, this.namingStyle);
        return this.prefix + transformedName + this.suffix;
    }

    public ConfigDef config() {
        ConfigDef config = new ConfigDef();
        Field.group((ConfigDef)config, null, (Field[])new Field[]{PREFIX, SUFFIX, NAMING_STYLE});
        return config;
    }

    public void close() {
    }

    public String version() {
        return Module.version();
    }

    record TransformedSchemaValue(Schema schema, Object value) {
    }
}

