/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.type;

import io.debezium.connector.jdbc.dialect.DatabaseDialect;
import io.debezium.connector.jdbc.type.JdbcType;
import io.debezium.sink.SinkConnectorConfig;
import io.debezium.sink.column.ColumnDescriptor;
import io.debezium.sink.valuebinding.ValueBindDescriptor;
import io.debezium.util.SchemaUtils;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.ConnectException;

public abstract class AbstractType
implements JdbcType {
    private DatabaseDialect dialect;

    @Override
    public void configure(SinkConnectorConfig config, DatabaseDialect dialect) {
        this.dialect = dialect;
    }

    public String getQueryBinding(ColumnDescriptor column, Schema schema, Object value) {
        return this.getDialect().getQueryBindingWithValueCast(column, schema, this);
    }

    public String getDefaultValueBinding(Schema schema, Object value) {
        switch (schema.type()) {
            case INT8: {
                return Byte.toString((Byte)value);
            }
            case INT16: {
                return Short.toString((Short)value);
            }
            case INT32: {
                return Integer.toString((Integer)value);
            }
            case INT64: {
                return Long.toString((Long)value);
            }
            case FLOAT32: {
                return Float.toString(((Float)value).floatValue());
            }
            case FLOAT64: {
                return Double.toString((Double)value);
            }
            case STRING: {
                return "'" + ((String)value).replaceAll("(?<!')'(?!')", "''") + "'";
            }
            case BOOLEAN: {
                return this.getDialect().getFormattedBoolean((Boolean)value);
            }
        }
        throw new IllegalArgumentException(String.format("No default value resolution for schema type %s with name %s and type %s", schema.type(), schema.name(), this.getClass().getName()));
    }

    public List<ValueBindDescriptor> bind(int index, Schema schema, Object value) {
        return List.of(new ValueBindDescriptor(index, value));
    }

    protected DatabaseDialect getDialect() {
        return this.dialect;
    }

    protected Optional<String> getSourceColumnType(Schema schema) {
        return SchemaUtils.getSourceColumnType((Schema)schema);
    }

    protected Optional<String> getSourceColumnSize(Schema schema) {
        return SchemaUtils.getSourceColumnSize((Schema)schema);
    }

    protected Optional<String> getSourceColumnPrecision(Schema schema) {
        return SchemaUtils.getSourceColumnPrecision((Schema)schema);
    }

    protected Optional<String> getSchemaParameter(Schema schema, String parameterName) {
        if (!Objects.isNull(schema.parameters())) {
            return Optional.ofNullable((String)schema.parameters().get(parameterName));
        }
        return Optional.empty();
    }

    protected void throwUnexpectedValue(Object value) throws ConnectException {
        throw new ConnectException(String.format("Unexpected %s value '%s' with type '%s'", this.getClass().getSimpleName(), value.toString(), value.getClass().getName()));
    }

    protected Struct requireStruct(Object value) throws ConnectException {
        if (value instanceof Struct) {
            Struct data = (Struct)value;
            return data;
        }
        this.throwUnexpectedValue(value);
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

