/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.type.connect;

import io.debezium.connector.jdbc.dialect.DatabaseDialect;
import io.debezium.connector.jdbc.type.connect.AbstractConnectSchemaType;
import io.debezium.connector.jdbc.util.ByteArrayUtils;
import io.debezium.sink.valuebinding.ValueBindDescriptor;
import java.util.List;
import org.apache.kafka.connect.data.Schema;
import org.hibernate.engine.jdbc.Size;

public class ConnectBytesType
extends AbstractConnectSchemaType {
    public static final ConnectBytesType INSTANCE = new ConnectBytesType();

    public String[] getRegistrationKeys() {
        return new String[]{"BYTES"};
    }

    @Override
    public String getDefaultValueBinding(Schema schema, Object value) {
        return String.format(this.getDialect().getByteArrayFormat(), ByteArrayUtils.getByteArrayAsHex(value));
    }

    @Override
    public String getTypeName(Schema schema, boolean isKey) {
        int columnSize = Integer.parseInt(this.getSourceColumnSize(schema).orElse("0"));
        DatabaseDialect dialect = this.getDialect();
        if (columnSize > 0) {
            return dialect.getJdbcTypeName(-3, Size.length((long)columnSize));
        }
        if (isKey) {
            return dialect.getJdbcTypeName(-3, Size.length((long)dialect.getMaxVarbinaryLength()));
        }
        return dialect.getJdbcTypeName(-3);
    }

    @Override
    public List<ValueBindDescriptor> bind(int index, Schema schema, Object value) {
        return List.of(new ValueBindDescriptor(index, value, Integer.valueOf(-3)));
    }
}

