/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.type.connect;

import io.debezium.connector.jdbc.dialect.DatabaseDialect;
import io.debezium.connector.jdbc.type.connect.AbstractConnectSchemaType;
import io.debezium.util.Strings;
import java.util.Optional;
import org.apache.kafka.connect.data.Schema;
import org.hibernate.engine.jdbc.Size;

public class ConnectStringType
extends AbstractConnectSchemaType {
    public static final ConnectStringType INSTANCE = new ConnectStringType();

    public String[] getRegistrationKeys() {
        return new String[]{"STRING"};
    }

    @Override
    public String getTypeName(Schema schema, boolean isKey) {
        int jdbcType;
        int resolvedJdbcType = this.getColumnSqlType(schema);
        DatabaseDialect dialect = this.getDialect();
        if (1111 != resolvedJdbcType) {
            int columnSize = this.getColumnSize(dialect, schema, resolvedJdbcType, isKey);
            if (columnSize == 0 && (1 == resolvedJdbcType || -15 == resolvedJdbcType)) {
                columnSize = 1;
            }
            if (columnSize > 0) {
                return dialect.getJdbcTypeName(resolvedJdbcType, Size.length((long)columnSize));
            }
            return dialect.getJdbcTypeName(resolvedJdbcType);
        }
        int n = jdbcType = this.hasNationalizedCharacterSet(schema) ? -9 : 12;
        if (isKey) {
            return dialect.getJdbcTypeName(jdbcType, Size.length((long)this.getMaxSizeInKey(dialect, jdbcType)));
        }
        return dialect.getJdbcTypeName(jdbcType);
    }

    private int getColumnSize(DatabaseDialect dialect, Schema schema, int jdbcType, boolean isKey) {
        int columnSize = Integer.parseInt(this.getSourceColumnSize(schema).orElse("0"));
        if (!isKey) {
            return columnSize;
        }
        int maxSizeInKey = this.getMaxSizeInKey(dialect, jdbcType);
        if (columnSize > 0) {
            return Math.min(columnSize, maxSizeInKey);
        }
        return maxSizeInKey;
    }

    private int getMaxSizeInKey(DatabaseDialect dialect, int jdbcType) {
        if (jdbcType == -15 || jdbcType == -9) {
            return dialect.getMaxNVarcharLengthInKey();
        }
        return dialect.getMaxVarcharLengthInKey();
    }

    private int getColumnSqlType(Schema schema) {
        Optional<String> columnType = this.getSourceColumnType(schema);
        if (columnType.isPresent()) {
            String type = columnType.get();
            if (ConnectStringType.isType(type, "CHAR", "CHARACTER", "BPCHAR")) {
                return this.hasNationalizedCharacterSet(schema) ? -15 : 1;
            }
            if (ConnectStringType.isType(type, "NCHAR")) {
                return -15;
            }
            if (ConnectStringType.isType(type, "VARCHAR", "VARCHAR2", "CHARACTER VARYING")) {
                return this.hasNationalizedCharacterSet(schema) ? -9 : 12;
            }
            if (ConnectStringType.isType(type, "NVARCHAR", "NVARCHAR2")) {
                return -9;
            }
        }
        return 1111;
    }

    private static boolean isType(String columnType, String ... possibilities) {
        for (String possibility : possibilities) {
            if (!possibility.equalsIgnoreCase(columnType)) continue;
            return true;
        }
        return false;
    }

    private boolean hasNationalizedCharacterSet(Schema schema) {
        if (schema.parameters() != null) {
            String charsetName = (String)schema.parameters().get("__debezium.source.column.character_set");
            return !Strings.isNullOrEmpty((String)charsetName) && charsetName.toLowerCase().startsWith("utf8");
        }
        return false;
    }
}

