/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.type.connect;

import io.debezium.connector.jdbc.type.AbstractTimeType;
import io.debezium.connector.jdbc.util.DateTimeUtils;
import io.debezium.sink.column.ColumnDescriptor;
import io.debezium.sink.valuebinding.ValueBindDescriptor;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;
import java.util.List;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.errors.ConnectException;

public class ConnectTimeType
extends AbstractTimeType {
    public static final ConnectTimeType INSTANCE = new ConnectTimeType();

    public String[] getRegistrationKeys() {
        return new String[]{"org.apache.kafka.connect.data.Time"};
    }

    @Override
    public String getQueryBinding(ColumnDescriptor column, Schema schema, Object value) {
        return this.getDialect().getTimeQueryBinding();
    }

    @Override
    public String getDefaultValueBinding(Schema schema, Object value) {
        return this.getDialect().getFormattedTime(DateTimeUtils.toZonedDateTimeFromDate((Date)value, this.getDatabaseTimeZone()));
    }

    @Override
    public List<ValueBindDescriptor> bind(int index, Schema schema, Object value) {
        if (value == null) {
            return List.of(new ValueBindDescriptor(index, null));
        }
        if (value instanceof Date) {
            LocalTime localTime = DateTimeUtils.toLocalTimeFromUtcDate((Date)value);
            LocalDateTime localDateTime = localTime.atDate(LocalDate.now());
            if (this.getDialect().isTimeZoneSet()) {
                return List.of(new ValueBindDescriptor(index, (Object)localDateTime.atZone(this.getDatabaseTimeZone().toZoneId()).toLocalDateTime().toLocalTime()));
            }
            return List.of(new ValueBindDescriptor(index, (Object)localDateTime.toLocalTime()));
        }
        throw new ConnectException(String.format("Unexpected %s value '%s' with type '%s'", this.getClass().getSimpleName(), value, value.getClass().getName()));
    }
}

