/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.type.debezium;

import io.debezium.connector.jdbc.type.AbstractTimestampType;
import io.debezium.sink.valuebinding.ValueBindDescriptor;
import java.time.LocalDateTime;
import java.util.List;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.errors.ConnectException;

public abstract class AbstractDebeziumTimestampType
extends AbstractTimestampType {
    @Override
    public List<ValueBindDescriptor> bind(int index, Schema schema, Object value) {
        if (value == null) {
            return List.of(new ValueBindDescriptor(index, null));
        }
        if (value instanceof Number) {
            LocalDateTime localDateTime = this.getLocalDateTime(((Number)value).longValue());
            if (this.getDialect().isTimeZoneSet()) {
                return List.of(new ValueBindDescriptor(index, (Object)localDateTime.atZone(this.getDatabaseTimeZone().toZoneId()).toLocalDateTime(), Integer.valueOf(this.getJdbcType())));
            }
            return List.of(new ValueBindDescriptor(index, (Object)localDateTime, Integer.valueOf(this.getJdbcType())));
        }
        throw new ConnectException(String.format("Unexpected %s value '%s' with type '%s'", this.getClass().getSimpleName(), value, value.getClass().getName()));
    }

    protected abstract LocalDateTime getLocalDateTime(long var1);
}

