/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.type.debezium;

import io.debezium.connector.jdbc.type.AbstractDateType;
import io.debezium.connector.jdbc.util.DateTimeUtils;
import io.debezium.sink.valuebinding.ValueBindDescriptor;
import java.util.List;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.errors.ConnectException;

public class DateType
extends AbstractDateType {
    public static final DateType INSTANCE = new DateType();

    public String[] getRegistrationKeys() {
        return new String[]{"io.debezium.time.Date"};
    }

    @Override
    public String getDefaultValueBinding(Schema schema, Object value) {
        return this.getDialect().getFormattedDate(DateTimeUtils.toLocalDateOfEpochDays(((Number)value).longValue()));
    }

    @Override
    public List<ValueBindDescriptor> bind(int index, Schema schema, Object value) {
        if (value == null) {
            return List.of(new ValueBindDescriptor(index, null));
        }
        if (value instanceof Number) {
            return List.of(new ValueBindDescriptor(index, (Object)DateTimeUtils.toLocalDateOfEpochDays(((Number)value).longValue())));
        }
        throw new ConnectException(String.format("Unexpected %s value '%s' with type '%s'", this.getClass().getSimpleName(), value, value.getClass().getName()));
    }
}

