/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.type.debezium;

import io.debezium.connector.jdbc.type.AbstractTimestampType;
import io.debezium.sink.valuebinding.ValueBindDescriptor;
import io.debezium.time.ZonedTimestamp;
import java.time.ZonedDateTime;
import java.util.List;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.errors.ConnectException;

public class DebeziumZonedTimestampType
extends AbstractTimestampType {
    public static final DebeziumZonedTimestampType INSTANCE = new DebeziumZonedTimestampType();
    public static final String POSITIVE_INFINITY = "infinity";
    public static final String NEGATIVE_INFINITY = "-infinity";

    public String[] getRegistrationKeys() {
        return new String[]{"io.debezium.time.ZonedTimestamp"};
    }

    @Override
    public String getDefaultValueBinding(Schema schema, Object value) {
        return this.getDialect().getFormattedTimestampWithTimeZone((String)value);
    }

    @Override
    public List<ValueBindDescriptor> bind(int index, Schema schema, Object value) {
        if (value == null) {
            return List.of(new ValueBindDescriptor(index, null));
        }
        if (value instanceof String) {
            if (POSITIVE_INFINITY.equals(value) || NEGATIVE_INFINITY.equals(value)) {
                return this.infinityTimestampValue(index, value);
            }
            return this.normalTimestampValue(index, value);
        }
        throw new ConnectException(String.format("Unexpected %s value '%s' with type '%s'", this.getClass().getSimpleName(), value, value.getClass().getName()));
    }

    protected List<ValueBindDescriptor> infinityTimestampValue(int index, Object value) {
        ZonedDateTime zdt = POSITIVE_INFINITY.equals(value) ? ZonedDateTime.parse(this.getDialect().getTimestampPositiveInfinityValue(), ZonedTimestamp.FORMATTER) : ZonedDateTime.parse(this.getDialect().getTimestampNegativeInfinityValue(), ZonedTimestamp.FORMATTER);
        return List.of(new ValueBindDescriptor(index, (Object)zdt.toOffsetDateTime(), Integer.valueOf(this.getJdbcBindType())));
    }

    protected List<ValueBindDescriptor> normalTimestampValue(int index, Object value) {
        ZonedDateTime zdt = ZonedDateTime.parse((String)value, ZonedTimestamp.FORMATTER).withZoneSameInstant(this.getDatabaseTimeZone().toZoneId());
        return List.of(new ValueBindDescriptor(index, (Object)zdt.toOffsetDateTime(), Integer.valueOf(this.getJdbcBindType())));
    }

    protected int getJdbcBindType() {
        return this.getJdbcType();
    }

    @Override
    protected int getJdbcType() {
        return 2014;
    }
}

