/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.type.debezium;

import io.debezium.connector.jdbc.dialect.DatabaseDialect;
import io.debezium.connector.jdbc.type.debezium.AbstractDebeziumTimeType;
import io.debezium.connector.jdbc.util.DateTimeUtils;
import java.time.LocalTime;
import org.apache.kafka.connect.data.Schema;
import org.hibernate.engine.jdbc.Size;

public class NanoTimeType
extends AbstractDebeziumTimeType {
    public static final NanoTimeType INSTANCE = new NanoTimeType();

    public String[] getRegistrationKeys() {
        return new String[]{"io.debezium.time.NanoTime"};
    }

    @Override
    public String getTypeName(Schema schema, boolean isKey) {
        int precision = this.getTimePrecision(schema);
        DatabaseDialect dialect = this.getDialect();
        if (precision > 0) {
            precision = Math.min(precision, dialect.getMaxTimePrecision());
            return dialect.getJdbcTypeName(92, Size.precision((int)precision));
        }
        return dialect.getJdbcTypeName(92, Size.precision((int)dialect.getMaxTimePrecision()));
    }

    @Override
    protected LocalTime getLocalTime(Number value) {
        return DateTimeUtils.toLocalTimeFromDurationNanoseconds(value.longValue());
    }
}

