/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.util;

import io.debezium.DebeziumException;
import java.util.stream.Stream;

public enum NamingStyle {
    SNAKE_CASE("snake_case"),
    CAMEL_CASE("camel_case"),
    UPPER_CASE("UPPER_CASE"),
    LOWER_CASE("lower_case"),
    DEFAULT("default");

    private final String value;

    private NamingStyle(String value) {
        this.value = value;
    }

    public static NamingStyle from(String value) {
        return Stream.of(NamingStyle.values()).filter(style -> style.value.equalsIgnoreCase(value) || style.name().equalsIgnoreCase(value)).findFirst().orElseThrow(() -> new DebeziumException("Invalid naming style: " + value + ". Allowed styles are: " + String.join((CharSequence)", ", NamingStyle.valuesAsString())));
    }

    public String getValue() {
        return this.value;
    }

    public static String[] valuesAsString() {
        return (String[])Stream.of(NamingStyle.values()).map(Enum::name).toArray(String[]::new);
    }
}

