/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.util;

import io.debezium.DebeziumException;
import io.debezium.connector.jdbc.util.NamingStyle;
import io.debezium.util.Strings;
import java.util.Locale;

public class NamingStyleUtils {
    public static String applyNamingStyle(String name, NamingStyle style) {
        if (name == null || style == null) {
            throw new DebeziumException("Name and style must not be null");
        }
        return switch (style) {
            case NamingStyle.SNAKE_CASE -> Strings.toSnakeCase((String)name);
            case NamingStyle.CAMEL_CASE -> Strings.convertDotAndUnderscoreStringToCamelCase((String)name);
            case NamingStyle.UPPER_CASE -> name.toUpperCase(Locale.ROOT);
            case NamingStyle.LOWER_CASE -> name.toLowerCase(Locale.ROOT);
            default -> name;
        };
    }
}

