/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import io.debezium.annotation.Immutable;
import io.debezium.connector.mongodb.ReplicaSet;
import io.debezium.util.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.apache.kafka.connect.util.ConnectorUtils;

@Immutable
public class ReplicaSets {
    private static final Pattern REPLICA_DELIMITER_PATTERN = Pattern.compile(";");
    private final Map<String, ReplicaSet> replicaSetsByName = new HashMap<String, ReplicaSet>();
    private final List<ReplicaSet> nonReplicaSets = new ArrayList<ReplicaSet>();

    public static ReplicaSets parse(String hosts) {
        HashSet<ReplicaSet> replicaSets = new HashSet<ReplicaSet>();
        if (hosts != null) {
            for (String replicaSetStr : REPLICA_DELIMITER_PATTERN.split(hosts.trim())) {
                if (replicaSetStr.isEmpty()) continue;
                ReplicaSet replicaSet = ReplicaSet.parse(replicaSetStr);
                if (replicaSetStr == null) continue;
                replicaSets.add(replicaSet);
            }
        }
        return new ReplicaSets(replicaSets);
    }

    public static ReplicaSets empty() {
        return new ReplicaSets(null);
    }

    public ReplicaSets(Collection<ReplicaSet> rsSpecs) {
        if (rsSpecs != null) {
            rsSpecs.forEach(replicaSet -> {
                if (replicaSet.hasReplicaSetName()) {
                    this.replicaSetsByName.put(replicaSet.replicaSetName(), (ReplicaSet)replicaSet);
                } else {
                    this.nonReplicaSets.add((ReplicaSet)replicaSet);
                }
            });
        }
        Collections.sort(this.nonReplicaSets);
    }

    public int replicaSetCount() {
        return this.replicaSetsByName.size() + this.nonReplicaSets.size();
    }

    public int validReplicaSetCount() {
        return this.replicaSetsByName.size();
    }

    public void onEachReplicaSet(Consumer<ReplicaSet> function) {
        this.replicaSetsByName.values().forEach(function);
        this.nonReplicaSets.forEach(function);
    }

    public void subdivide(int maxSubdivisionCount, Consumer<ReplicaSets> subdivisionConsumer) {
        int numGroups = Math.min(this.replicaSetCount(), maxSubdivisionCount);
        if (numGroups <= 1) {
            subdivisionConsumer.accept(this);
            return;
        }
        ConnectorUtils.groupPartitions(this.all(), (int)numGroups).forEach(rsList -> subdivisionConsumer.accept(new ReplicaSets((Collection<ReplicaSet>)rsList)));
    }

    public List<ReplicaSet> all() {
        ArrayList<ReplicaSet> replicaSets = new ArrayList<ReplicaSet>();
        replicaSets.addAll(this.replicaSetsByName.values());
        replicaSets.addAll(this.nonReplicaSets);
        return replicaSets;
    }

    public List<ReplicaSet> validReplicaSets() {
        ArrayList<ReplicaSet> replicaSets = new ArrayList<ReplicaSet>();
        replicaSets.addAll(this.replicaSetsByName.values());
        return replicaSets;
    }

    public List<ReplicaSet> unnamedReplicaSets() {
        ArrayList<ReplicaSet> replicaSets = new ArrayList<ReplicaSet>();
        replicaSets.addAll(this.nonReplicaSets);
        return replicaSets;
    }

    public boolean haveChangedSince(ReplicaSets priorState) {
        if (priorState.replicaSetCount() != this.replicaSetCount()) {
            return true;
        }
        if (this.replicaSetsByName.size() != priorState.replicaSetsByName.size()) {
            return true;
        }
        if (!this.replicaSetsByName.isEmpty() && !this.replicaSetsByName.keySet().equals(priorState.replicaSetsByName.keySet())) {
            return true;
        }
        return !this.nonReplicaSets.equals(priorState.nonReplicaSets);
    }

    public String hosts() {
        return Strings.join((CharSequence)";", this.all());
    }

    public int hashCode() {
        return Objects.hash(this.replicaSetsByName, this.nonReplicaSets);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ReplicaSets) {
            ReplicaSets that = (ReplicaSets)obj;
            return this.replicaSetsByName.equals(that.replicaSetsByName) && this.nonReplicaSets.equals(that.nonReplicaSets);
        }
        return false;
    }

    public String toString() {
        return this.hosts();
    }
}

