/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb.snapshot;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import io.debezium.connector.mongodb.CollectionId;
import io.debezium.connector.mongodb.connection.MongoDbConnection;
import io.debezium.function.BlockingConsumer;
import io.debezium.pipeline.source.snapshot.incremental.WatermarkWindowCloser;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Partition;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDbInsertWindowCloser
implements WatermarkWindowCloser {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoDbInsertWindowCloser.class);
    private static final String DOCUMENT_ID = "_id";
    private final MongoDbConnection mongoDbConnection;
    private final CollectionId collectionId;

    public MongoDbInsertWindowCloser(MongoDbConnection jdbcConnection, CollectionId collectionId) {
        this.mongoDbConnection = jdbcConnection;
        this.collectionId = collectionId;
    }

    public void closeWindow(Partition partition, OffsetContext offsetContext, String chunkId) throws InterruptedException {
        this.mongoDbConnection.execute("emit window close for chunk '" + chunkId + "'", (BlockingConsumer<MongoClient>)((BlockingConsumer)client -> {
            MongoDatabase database = client.getDatabase(this.collectionId.dbName());
            MongoCollection collection = database.getCollection(this.collectionId.name());
            LOGGER.trace("Emitting close window for chunk = '{}'", (Object)chunkId);
            Document signal = new Document();
            signal.put(DOCUMENT_ID, (Object)(chunkId + "-close"));
            signal.put("type", (Object)"snapshot-window-close");
            signal.put("payload", (Object)"");
            collection.insertOne((Object)signal);
        }));
    }
}

