/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb.transforms;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.EnumeratedValue;
import io.debezium.config.Field;
import io.debezium.connector.mongodb.transforms.MongoDataConverter;
import io.debezium.data.Envelope;
import io.debezium.schema.FieldNameSelector;
import io.debezium.schema.SchemaNameAdjuster;
import io.debezium.transforms.AbstractExtractNewRecordState;
import io.debezium.transforms.ConnectRecordUtil;
import io.debezium.transforms.ExtractNewRecordStateConfigDefinition;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.header.Headers;
import org.apache.kafka.connect.transforms.ExtractField;
import org.apache.kafka.connect.transforms.Flatten;
import org.apache.kafka.connect.transforms.util.Requirements;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtractNewDocumentState<R extends ConnectRecord<R>>
extends AbstractExtractNewRecordState<R> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtractNewDocumentState.class);
    private static final Field ARRAY_ENCODING = Field.create((String)"array.encoding").withDisplayName("Array encoding").withEnum(ArrayEncoding.class, (Enum)ArrayEncoding.ARRAY).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("The arrays can be encoded using 'array' schema type (the default) or as a 'document' (similar to how BSON encodes arrays). 'array' is easier to consume but requires all elements in the array to be of the same type. Use 'document' if the arrays in data source mix different types together.");
    private static final Field FLATTEN_STRUCT = Field.create((String)"flatten.struct").withDisplayName("Flatten struct").withType(ConfigDef.Type.BOOLEAN).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(false).withDescription("Flattening structs by concatenating the fields into plain properties, using a (configurable) delimiter.");
    private static final Field DELIMITER = Field.create((String)"flatten.struct.delimiter").withDisplayName("Delimiter for flattened struct").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault("_").withDescription("Delimiter to concat between field names from the input record when generating field names for theoutput record.");
    private ExtractField<R> keyExtractor;
    private Flatten<R> recordFlattener;
    private MongoDataConverter converter;
    private boolean flattenStruct;
    private String delimiter;
    private final Field.Set configFields = ExtractNewRecordStateConfigDefinition.CONFIG_FIELDS.with(new Field[]{ARRAY_ENCODING, FLATTEN_STRUCT, DELIMITER});

    public void configure(Map<String, ?> configs) {
        super.configure(configs);
        CommonConnectorConfig.FieldNameAdjustmentMode fieldNameAdjustmentMode = CommonConnectorConfig.FieldNameAdjustmentMode.parse((String)this.config.getString(CommonConnectorConfig.FIELD_NAME_ADJUSTMENT_MODE));
        SchemaNameAdjuster fieldNameAdjuster = fieldNameAdjustmentMode.createAdjuster();
        this.converter = new MongoDataConverter(ArrayEncoding.parse(this.config.getString(ARRAY_ENCODING)), (FieldNameSelector.FieldNamer<String>)FieldNameSelector.defaultNonRelationalSelector((SchemaNameAdjuster)fieldNameAdjuster), fieldNameAdjustmentMode != CommonConnectorConfig.FieldNameAdjustmentMode.NONE);
        this.flattenStruct = this.config.getBoolean(FLATTEN_STRUCT);
        this.delimiter = this.config.getString(DELIMITER);
        this.keyExtractor = ConnectRecordUtil.extractKeyDelegate((String)"id");
        this.recordFlattener = ConnectRecordUtil.flattenValueDelegate((String)this.delimiter);
    }

    public R doApply(R record) {
        ConnectRecord newRecord;
        if (!this.smtManager.isValidKey(record)) {
            return record;
        }
        if (!this.additionalHeaders.isEmpty()) {
            Headers headersToAdd = this.makeHeaders(this.additionalHeaders, (Struct)record.value());
            headersToAdd.forEach(h -> record.headers().add(h));
        }
        ConnectRecord keyRecord = this.keyExtractor.apply(record);
        BsonDocument keyDocument = BsonDocument.parse((String)("{ \"id\" : " + keyRecord.key().toString() + "}"));
        BsonDocument valueDocument = new BsonDocument();
        if (record.value() == null) {
            ConnectRecord newRecord2 = this.extractRecordStrategy.handleTombstoneRecord(record);
            if (newRecord2 == null) {
                return null;
            }
            return this.newRecord(record, keyDocument, valueDocument);
        }
        if (!this.smtManager.isValidEnvelope(record)) {
            return record;
        }
        ConnectRecord afterRecord = this.extractRecordStrategy.afterDelegate().apply(record);
        ConnectRecord updateDescriptionRecord = this.extractRecordStrategy.updateDescriptionDelegate().apply(record);
        boolean isDeletion = false;
        if (afterRecord.value() == null && updateDescriptionRecord.value() == null) {
            isDeletion = true;
            newRecord = this.extractRecordStrategy.handleDeleteRecord(record);
            if (newRecord == null) {
                return null;
            }
        } else {
            newRecord = this.extractRecordStrategy.handleRecord(record);
        }
        if (newRecord.value() != null) {
            valueDocument = this.getFullDocument(newRecord, keyDocument);
        }
        if (newRecord.value() == null && updateDescriptionRecord.value() != null) {
            valueDocument = this.getPartialUpdateDocument(newRecord, updateDescriptionRecord, keyDocument);
        }
        if (this.extractRecordStrategy.isRewriteMode()) {
            valueDocument.append("__deleted", (BsonValue)new BsonBoolean(isDeletion));
        }
        return this.newRecord(record, keyDocument, valueDocument);
    }

    public Iterable<Field> validateConfigFields() {
        return this.configFields;
    }

    public ConfigDef config() {
        ConfigDef config = new ConfigDef();
        Field.group((ConfigDef)config, null, (Field[])this.configFields.asArray());
        return config;
    }

    public void close() {
        super.close();
        this.keyExtractor.close();
        this.recordFlattener.close();
    }

    private R newRecord(R record, BsonDocument keyDocument, BsonDocument valueDocument) {
        SchemaBuilder keySchemaBuilder = SchemaBuilder.struct();
        Set keyPairs = keyDocument.entrySet();
        for (Map.Entry keyPairsForSchema : keyPairs) {
            this.converter.addFieldSchema(keyPairsForSchema, keySchemaBuilder);
        }
        Schema finalKeySchema = keySchemaBuilder.build();
        Struct finalKeyStruct = new Struct(finalKeySchema);
        for (Map.Entry keyPairsForStruct : keyPairs) {
            this.converter.convertRecord(keyPairsForStruct, finalKeySchema, finalKeyStruct);
        }
        Schema finalValueSchema = null;
        Struct finalValueStruct = null;
        if (!valueDocument.isEmpty()) {
            String newValueSchemaName = record.valueSchema().name();
            if (Envelope.isEnvelopeSchema((String)newValueSchemaName)) {
                newValueSchemaName = newValueSchemaName.substring(0, newValueSchemaName.length() - 9);
            }
            SchemaBuilder valueSchemaBuilder = SchemaBuilder.struct().name(newValueSchemaName);
            Set valuePairs = valueDocument.entrySet();
            for (Map.Entry valuePairsForSchema : valuePairs) {
                this.converter.addFieldSchema(valuePairsForSchema, valueSchemaBuilder);
            }
            if (!this.additionalFields.isEmpty()) {
                this.addAdditionalFieldsSchema(this.additionalFields, record, valueSchemaBuilder);
            }
            finalValueSchema = valueSchemaBuilder.build();
            finalValueStruct = new Struct(finalValueSchema);
            for (Map.Entry valuePairsForStruct : valuePairs) {
                this.converter.convertRecord(valuePairsForStruct, finalValueSchema, finalValueStruct);
            }
            if (!this.additionalFields.isEmpty()) {
                this.addFields(this.additionalFields, record, finalValueStruct);
            }
        }
        ConnectRecord newRecord = record.newRecord(record.topic(), record.kafkaPartition(), finalKeySchema, (Object)finalKeyStruct, finalValueSchema, finalValueStruct, record.timestamp());
        if (this.flattenStruct) {
            return (R)this.recordFlattener.apply(newRecord);
        }
        return (R)newRecord;
    }

    private void addAdditionalFieldsSchema(List<AbstractExtractNewRecordState.FieldReference> additionalFields, R originalRecord, SchemaBuilder valueSchemaBuilder) {
        Schema sourceSchema = originalRecord.valueSchema();
        for (AbstractExtractNewRecordState.FieldReference fieldReference : additionalFields) {
            Optional fieldSchema = fieldReference.getSchema(sourceSchema);
            fieldSchema.ifPresent(schema -> valueSchemaBuilder.field(fieldReference.getNewField(), schema));
        }
    }

    private void addFields(List<AbstractExtractNewRecordState.FieldReference> additionalFields, R originalRecord, Struct value) {
        Struct originalRecordValue = (Struct)originalRecord.value();
        for (AbstractExtractNewRecordState.FieldReference fieldReference : additionalFields) {
            value.put(fieldReference.getNewField(), fieldReference.getValue(originalRecordValue));
        }
    }

    private BsonDocument getPartialUpdateDocument(R beforeRecord, R updateDescriptionRecord, BsonDocument keyDocument) {
        BsonDocument valueDocument = new BsonDocument();
        Struct updateDescription = Requirements.requireStruct((Object)updateDescriptionRecord.value(), (String)"updateDescription");
        String updated = updateDescription.getString("updatedFields");
        List removed = updateDescription.getArray("removedFields");
        if (beforeRecord.value() != null) {
            valueDocument = BsonDocument.parse((String)beforeRecord.value().toString());
        }
        if (updated != null) {
            BsonDocument updatedBson = BsonDocument.parse((String)updated);
            for (Map.Entry valueEntry : updatedBson.entrySet()) {
                valueDocument.append((String)valueEntry.getKey(), (BsonValue)valueEntry.getValue());
            }
        }
        if (removed != null) {
            for (String field : removed) {
                valueDocument.keySet().remove(field);
            }
        }
        if (!valueDocument.containsKey((Object)"_id")) {
            valueDocument.append("_id", keyDocument.get((Object)"id"));
        }
        if (this.flattenStruct) {
            BsonDocument newDocument = new BsonDocument();
            valueDocument.forEach((fKey, fValue) -> newDocument.put(fKey.replace(".", this.delimiter), fValue));
            valueDocument = newDocument;
        }
        return valueDocument;
    }

    private BsonDocument getFullDocument(R record, BsonDocument key) {
        return BsonDocument.parse((String)record.value().toString());
    }

    public static enum ArrayEncoding implements EnumeratedValue
    {
        ARRAY("array"),
        DOCUMENT("document");

        private final String value;

        private ArrayEncoding(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static ArrayEncoding parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (ArrayEncoding option : ArrayEncoding.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static ArrayEncoding parse(String value, String defaultValue) {
            ArrayEncoding mode = ArrayEncoding.parse(value);
            if (mode == null && defaultValue != null) {
                mode = ArrayEncoding.parse(defaultValue);
            }
            return mode;
        }
    }
}

