/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import com.mongodb.client.MongoChangeStreamCursor;
import com.mongodb.client.model.changestream.ChangeStreamDocument;
import io.debezium.annotation.Immutable;
import io.debezium.annotation.NotThreadSafe;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.SnapshotRecord;
import io.debezium.connector.common.BaseSourceInfo;
import io.debezium.connector.mongodb.CollectionId;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.connector.mongodb.MongoUtils;
import io.debezium.connector.mongodb.ResumeTokens;
import io.debezium.connector.mongodb.events.BufferingChangeStreamCursor;
import java.time.Instant;
import java.util.Optional;
import org.bson.BsonDocument;
import org.bson.BsonTimestamp;

@NotThreadSafe
public final class SourceInfo
extends BaseSourceInfo {
    public static final String RESUME_TOKEN = "resume_token";
    public static final String TIMESTAMP = "sec";
    public static final String ORDER = "ord";
    public static final String INITIAL_SYNC = "initsync";
    public static final String COLLECTION = "collection";
    public static final String LSID = "lsid";
    public static final String TXN_NUMBER = "txnNumber";
    public static final String WALL_TIME = "wallTime";
    private static final BsonTimestamp INITIAL_TIMESTAMP = new BsonTimestamp();
    private static final Position INITIAL_POSITION = new Position(INITIAL_TIMESTAMP, null, null);
    public boolean initialSnapshot = false;
    private final MongoDbConnectorConfig connectorConfig;
    private CollectionId collectionId;
    private Position position = null;
    private long wallTime;

    public SourceInfo(MongoDbConnectorConfig connectorConfig) {
        super((CommonConnectorConfig)connectorConfig);
        this.connectorConfig = connectorConfig;
    }

    CollectionId collectionId() {
        return this.collectionId;
    }

    Position position() {
        return this.position != null ? this.position : INITIAL_POSITION;
    }

    public String lastResumeToken() {
        return this.position != null ? this.position.resumeToken : null;
    }

    public BsonTimestamp lastTimestamp() {
        return this.position != null ? this.position.getTimestamp() : null;
    }

    public void collectionEvent(CollectionId collectionId, long wallTime) {
        this.onEvent(collectionId, this.position, wallTime);
    }

    public void initEvent(MongoChangeStreamCursor<ChangeStreamDocument<BsonDocument>> cursor) {
        if (cursor == null) {
            return;
        }
        ChangeStreamDocument result = (ChangeStreamDocument)cursor.tryNext();
        if (result == null) {
            this.noEvent(cursor);
        } else {
            this.changeStreamEvent((ChangeStreamDocument<BsonDocument>)result);
        }
    }

    public void noEvent(BufferingChangeStreamCursor.ResumableChangeStreamEvent<BsonDocument> event) {
        if (event.hasDocument()) {
            return;
        }
        this.noEvent(ResumeTokens.toBase64(event.resumeToken));
    }

    public void noEvent(MongoChangeStreamCursor<?> cursor) {
        if (cursor == null || cursor.getResumeToken() == null) {
            return;
        }
        this.noEvent(ResumeTokens.toBase64(cursor.getResumeToken()));
    }

    public void noEvent(BsonTimestamp timestamp) {
        if (timestamp == null) {
            return;
        }
        Position position = Position.changeStreamPosition(timestamp, null, null);
        this.noEvent(position);
    }

    private void noEvent(String resumeToken) {
        if (resumeToken == null) {
            return;
        }
        Position position = Position.changeStreamPosition(null, resumeToken, null);
        this.noEvent(position);
    }

    private void noEvent(Position position) {
        String namespace = "";
        long wallTime = 0L;
        this.onEvent(CollectionId.parse(namespace), position, wallTime);
    }

    public void changeStreamEvent(ChangeStreamDocument<BsonDocument> changeStreamEvent) {
        Position position = INITIAL_POSITION;
        String namespace = "";
        long wallTime = 0L;
        if (changeStreamEvent != null) {
            String resumeToken = ResumeTokens.toBase64(changeStreamEvent.getResumeToken());
            BsonTimestamp ts = changeStreamEvent.getClusterTime();
            position = Position.changeStreamPosition(ts, resumeToken, MongoUtils.getChangeStreamSessionTransactionId(changeStreamEvent));
            namespace = changeStreamEvent.getNamespace().getFullName();
            if (changeStreamEvent.getWallTime() != null) {
                wallTime = changeStreamEvent.getWallTime().getValue();
            }
        }
        this.onEvent(CollectionId.parse(namespace), position, wallTime);
    }

    private void onEvent(CollectionId collectionId, Position position, long wallTime) {
        this.position = position == null ? INITIAL_POSITION : position;
        this.collectionId = collectionId;
        this.wallTime = wallTime;
    }

    public boolean hasPosition() {
        return this.position != null;
    }

    public void setPosition(Position position) {
        this.position = position;
    }

    public void startInitialSnapshot() {
        this.initialSnapshot = true;
    }

    public void stopInitialSnapshot() {
        this.initialSnapshot = false;
    }

    public boolean isSnapshotRunning() {
        return this.initialSnapshot;
    }

    protected Instant timestamp() {
        return Instant.ofEpochSecond(this.position().getTime());
    }

    public SnapshotRecord snapshot() {
        return this.isSnapshotRunning() ? SnapshotRecord.TRUE : (this.snapshotRecord == SnapshotRecord.INCREMENTAL ? SnapshotRecord.INCREMENTAL : SnapshotRecord.FALSE);
    }

    protected String database() {
        return this.collectionId != null ? this.collectionId.dbName() : null;
    }

    long wallTime() {
        return this.wallTime;
    }

    public String toString() {
        return "SourceInfo [initialSync=" + this.initialSnapshot + ", collectionId=" + String.valueOf(this.collectionId) + ", position=" + String.valueOf(this.position) + "]";
    }

    @Immutable
    protected static final class Position {
        private final BsonTimestamp ts;
        private final SessionTransactionId changeStreamSessionTxnId;
        private final String resumeToken;

        public Position(BsonTimestamp ts, SessionTransactionId changeStreamsSessionTxnId, String resumeToken) {
            this.ts = ts;
            this.changeStreamSessionTxnId = changeStreamsSessionTxnId;
            this.resumeToken = resumeToken;
        }

        public static Position changeStreamPosition(BsonTimestamp ts, String resumeToken, SessionTransactionId sessionTxnId) {
            return new Position(ts, sessionTxnId, resumeToken);
        }

        public BsonTimestamp getTimestamp() {
            return this.ts;
        }

        public int getTime() {
            return this.ts != null ? this.ts.getTime() : 0;
        }

        public int getInc() {
            return this.ts != null ? this.ts.getInc() : -1;
        }

        public SessionTransactionId getChangeStreamSessionTxnId() {
            return this.changeStreamSessionTxnId;
        }

        public Optional<String> getResumeToken() {
            return Optional.ofNullable(this.resumeToken);
        }

        public String toString() {
            return "Position [ts=" + String.valueOf(this.ts) + ", changeStreamSessionTxnId=" + String.valueOf(this.changeStreamSessionTxnId) + ", resumeToken=" + this.resumeToken + "]";
        }
    }

    static final class SessionTransactionId {
        public final String lsid;
        public final Long txnNumber;

        SessionTransactionId(String lsid, Long txnNumber) {
            this.txnNumber = txnNumber;
            this.lsid = lsid;
        }
    }
}

