/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb.sink;

import com.mongodb.client.MongoClient;
import io.debezium.bindings.kafka.KafkaDebeziumSinkRecord;
import io.debezium.config.Configuration;
import io.debezium.connector.mongodb.connection.MongoDbConnectionContext;
import io.debezium.connector.mongodb.sink.Module;
import io.debezium.connector.mongodb.sink.MongoDbChangeEventSink;
import io.debezium.connector.mongodb.sink.MongoDbSinkConnectorConfig;
import io.debezium.dlq.ErrorReporter;
import java.util.Collection;
import java.util.Map;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.sink.ErrantRecordReporter;
import org.apache.kafka.connect.sink.SinkRecord;
import org.apache.kafka.connect.sink.SinkTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDbSinkConnectorTask
extends SinkTask {
    static final Logger LOGGER = LoggerFactory.getLogger(MongoDbSinkConnectorTask.class);
    private static final String CONNECTOR_TYPE = "sink";
    private MongoDbChangeEventSink mongoSink;

    public String version() {
        return Module.version();
    }

    public void start(Map<String, String> props) {
        LOGGER.info("Starting MongoDB sink task");
        Configuration config = Configuration.from(props);
        MongoDbSinkConnectorConfig sinkConfig = new MongoDbSinkConnectorConfig(config);
        MongoClient client = null;
        try {
            MongoDbConnectionContext connectionContext = new MongoDbConnectionContext(config);
            client = connectionContext.getMongoClient();
            this.mongoSink = new MongoDbChangeEventSink(sinkConfig, client, this.createErrorReporter());
        }
        catch (RuntimeException taskStartingException) {
            try {
                MongoClient autoCloseableClient = client;
                if (autoCloseableClient != null) {
                    autoCloseableClient.close();
                }
            }
            catch (RuntimeException resourceReleasingException) {
                taskStartingException.addSuppressed(resourceReleasingException);
            }
            throw new ConnectException("Failed to start MongoDB sink task", (Throwable)taskStartingException);
        }
        LOGGER.debug("Started MongoDB sink task");
    }

    public void put(Collection<SinkRecord> records) {
        this.mongoSink.execute(records);
    }

    public void flush(Map<TopicPartition, OffsetAndMetadata> currentOffsets) {
        LOGGER.debug("Flush called - noop");
    }

    public void stop() {
        LOGGER.info("Stopping MongoDB sink task");
        if (this.mongoSink != null) {
            this.mongoSink.close();
        }
    }

    private ErrorReporter createErrorReporter() {
        ErrorReporter result = MongoDbSinkConnectorTask.nopErrorReporter();
        if (this.context != null) {
            try {
                ErrantRecordReporter errantRecordReporter = this.context.errantRecordReporter();
                if (errantRecordReporter != null) {
                    result = (record, e) -> {
                        if (record instanceof KafkaDebeziumSinkRecord) {
                            KafkaDebeziumSinkRecord kafkaRecord = (KafkaDebeziumSinkRecord)record;
                            errantRecordReporter.report(kafkaRecord.getOriginalKafkaRecord(), (Throwable)e);
                        }
                    };
                } else {
                    LOGGER.info("Errant record reporter not configured.");
                }
            }
            catch (NoClassDefFoundError | NoSuchMethodError e2) {
                LOGGER.info("Kafka versions prior to 2.6 do not support the errant record reporter.");
            }
        }
        return result;
    }

    static ErrorReporter nopErrorReporter() {
        return (record, e) -> {};
    }
}

