/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import io.debezium.util.HexConverter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Base64;
import org.bson.BsonBinaryReader;
import org.bson.BsonBinaryWriter;
import org.bson.BsonDocument;
import org.bson.BsonReader;
import org.bson.BsonString;
import org.bson.BsonTimestamp;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.io.BasicOutputBuffer;
import org.bson.io.BsonOutput;

public final class ResumeTokens {
    public static BsonTimestamp getTimestamp(BsonDocument resumeToken) {
        BsonValue data = ResumeTokens.getData(resumeToken);
        byte[] dataBytes = ResumeTokens.getDataBytes(data);
        ByteBuffer dataBuffer = ByteBuffer.wrap(dataBytes).order(ByteOrder.BIG_ENDIAN);
        int canonicalType = dataBuffer.get() & 0xFF;
        if (canonicalType != 130) {
            throw new IllegalArgumentException("Expected canonical type equal to 130, but found " + canonicalType);
        }
        long timestampAsLong = dataBuffer.asLongBuffer().get();
        return new BsonTimestamp(timestampAsLong);
    }

    public static String toBase64(BsonDocument resumeToken) {
        BasicOutputBuffer out = new BasicOutputBuffer();
        BsonBinaryWriter writer = new BsonBinaryWriter((BsonOutput)out);
        BsonDocumentCodec codec = new BsonDocumentCodec();
        EncoderContext context = EncoderContext.builder().build();
        codec.encode((BsonWriter)writer, resumeToken, context);
        return Base64.getEncoder().encodeToString(out.toByteArray());
    }

    public static BsonDocument fromBase64(String data) {
        byte[] bytes = Base64.getDecoder().decode(data);
        BsonBinaryReader reader = new BsonBinaryReader(ByteBuffer.wrap(bytes));
        BsonDocumentCodec codec = new BsonDocumentCodec();
        DecoderContext context = DecoderContext.builder().build();
        return codec.decode((BsonReader)reader, context);
    }

    public static BsonValue getData(BsonDocument resumeToken) {
        if (!resumeToken.containsKey((Object)"_data")) {
            throw new IllegalArgumentException("Expected _data field in resume token");
        }
        return resumeToken.get((Object)"_data");
    }

    public static BsonDocument fromData(String data) {
        return data == null ? null : new BsonDocument("_data", (BsonValue)new BsonString(data));
    }

    private static byte[] getDataBytes(BsonValue data) {
        if (data.isString()) {
            String hexString = data.asString().getValue();
            return HexConverter.convertFromHex((String)hexString);
        }
        if (data.isBinary()) {
            return data.asBinary().getData();
        }
        throw new IllegalArgumentException("Expected binary or string for _data field in resume token but found " + String.valueOf(data.getBsonType()));
    }

    private ResumeTokens() {
        throw new AssertionError((Object)(this.getClass().getName() + " should not be instantiated"));
    }
}

