/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb.sink;

import com.mongodb.ConnectionString;
import io.debezium.config.ConfigDefinition;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.mongodb.shared.SharedMongoDbConnectorConfig;
import io.debezium.connector.mongodb.sink.DefaultWriteModelStrategy;
import io.debezium.connector.mongodb.sink.DeleteDefaultStrategy;
import io.debezium.connector.mongodb.sink.Module;
import io.debezium.connector.mongodb.sink.WriteModelStrategy;
import io.debezium.sink.SinkConnectorConfig;
import io.debezium.sink.filter.FieldFilterFactory;
import io.debezium.sink.naming.CollectionNamingStrategy;
import io.debezium.sink.naming.ColumnNamingStrategy;
import io.debezium.sink.naming.DefaultColumnNamingStrategy;
import io.debezium.util.Strings;
import java.util.function.Consumer;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.errors.ConnectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDbSinkConnectorConfig
implements SharedMongoDbConnectorConfig,
SinkConnectorConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoDbSinkConnectorConfig.class);
    public static final String ID_FIELD = "_id";
    public static final String SINK_DATABASE = "sink.database";
    public static final String COLUMN_NAMING_STRATEGY = "column.naming.strategy";
    public static final String FIELD_INCLUDE_LIST = "field.include.list";
    public static final String FIELD_EXCLUDE_LIST = "field.exclude.list";
    public static final Field SINK_DATABASE_NAME = Field.create((String)"sink.database").withDisplayName("The sink MongoDB database name.").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)2)).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.HIGH).withDescription("The name of the MongoDB database to which the connector writes to.").required();
    public static final Field COLUMN_NAMING_STRATEGY_FIELD = Field.create((String)"column.naming.strategy").withDisplayName("ColumnNamingStrategy class").withType(ConfigDef.Type.CLASS).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR_ADVANCED, (int)3)).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.LOW).withDefault(DefaultColumnNamingStrategy.class.getName()).withDescription("The fully qualified name of the class that provide the column naming strategy. It must implement the ColumnNamingStrategy interface.");
    protected static final ConfigDefinition CONFIG_DEFINITION = ConfigDefinition.editor().connector(new Field[]{SINK_DATABASE_NAME, CONNECTION_STRING, COLLECTION_NAMING_STRATEGY_FIELD, COLLECTION_NAME_FORMAT_FIELD, COLUMN_NAMING_STRATEGY_FIELD, BATCH_SIZE_FIELD}).create();
    public static Field.Set ALL_FIELDS = Field.setOf((Iterable)CONFIG_DEFINITION.all());
    private final Configuration config;
    private final ConnectionString connectionString;
    private final String sinkDatabaseName;
    private final String collectionNameFormat;
    private final CollectionNamingStrategy collectionNamingStrategy;
    private final ColumnNamingStrategy columnNamingStrategy;
    private FieldFilterFactory.FieldNameFilter fieldsFilter;
    private final int batchSize;
    private final boolean truncateEnabled;
    private final boolean deleteEnabled;
    private final String cloudEventsSchemaNamePattern;

    public WriteModelStrategy getWriteModelStrategy() {
        return new DefaultWriteModelStrategy();
    }

    public WriteModelStrategy getDeleteWriteModelStrategy() {
        return new DeleteDefaultStrategy();
    }

    public MongoDbSinkConnectorConfig(Configuration config) {
        this.config = config;
        this.connectionString = this.resolveConnectionString(config);
        this.sinkDatabaseName = config.getString(SINK_DATABASE_NAME);
        this.collectionNameFormat = config.getString(COLLECTION_NAME_FORMAT_FIELD);
        this.collectionNamingStrategy = (CollectionNamingStrategy)config.getInstance(COLLECTION_NAMING_STRATEGY_FIELD, CollectionNamingStrategy.class);
        this.columnNamingStrategy = (ColumnNamingStrategy)config.getInstance(COLUMN_NAMING_STRATEGY_FIELD, ColumnNamingStrategy.class);
        String fieldExcludeList = config.getString(FIELD_EXCLUDE_LIST);
        String fieldIncludeList = config.getString(FIELD_INCLUDE_LIST);
        this.fieldsFilter = FieldFilterFactory.createFieldFilter((String)fieldIncludeList, (String)fieldExcludeList);
        this.truncateEnabled = config.getBoolean(SinkConnectorConfig.TRUNCATE_ENABLED_FIELD);
        this.deleteEnabled = config.getBoolean(DELETE_ENABLED_FIELD);
        this.batchSize = config.getInteger(BATCH_SIZE_FIELD);
        this.cloudEventsSchemaNamePattern = config.getString(CLOUDEVENTS_SCHEMA_NAME_PATTERN_FIELD);
    }

    public void validate() {
        if (!this.config.validateAndRecord((Iterable)ALL_FIELDS, arg_0 -> ((Logger)LOGGER).error(arg_0))) {
            throw new ConnectException("Error configuring an instance of " + this.getClass().getSimpleName() + "; check the logs for details");
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Starting {} with configuration:", (Object)this.getClass().getSimpleName());
            this.config.withMaskedPasswords().forEach((propName, propValue) -> LOGGER.info("   {} = {}", propName, propValue));
        }
        String columnExcludeList = this.config.getString(FIELD_EXCLUDE_LIST);
        String columnIncludeList = this.config.getString(FIELD_INCLUDE_LIST);
        if (!Strings.isNullOrEmpty((String)columnExcludeList) && !Strings.isNullOrEmpty((String)columnIncludeList)) {
            throw new ConnectException("Cannot define both column.exclude.list and column.include.list. Please specify only one.");
        }
    }

    public boolean validateAndRecord(Iterable<Field> fields, Consumer<String> problems) {
        return this.config.validateAndRecord(fields, problems);
    }

    public static ConfigDef configDef() {
        return CONFIG_DEFINITION.configDef();
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public CollectionNamingStrategy getCollectionNamingStrategy() {
        return this.collectionNamingStrategy;
    }

    public FieldFilterFactory.FieldNameFilter getFieldFilter() {
        return this.fieldsFilter;
    }

    public ColumnNamingStrategy getColumnNamingStrategy() {
        return this.columnNamingStrategy;
    }

    public String getContextName() {
        return Module.contextName();
    }

    public String getConnectorName() {
        return Module.name();
    }

    public ConnectionString getConnectionString() {
        return this.connectionString;
    }

    public String getSinkDatabaseName() {
        return this.sinkDatabaseName;
    }

    public String getCollectionNameFormat() {
        return this.collectionNameFormat;
    }

    public SinkConnectorConfig.PrimaryKeyMode getPrimaryKeyMode() {
        return null;
    }

    public boolean isTruncateEnabled() {
        return this.truncateEnabled;
    }

    public boolean isDeleteEnabled() {
        return this.deleteEnabled;
    }

    public String useTimeZone() {
        return "UTC";
    }

    public String cloudEventsSchemaNamePattern() {
        return this.cloudEventsSchemaNamePattern;
    }
}

