/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb.transforms;

import io.debezium.DebeziumException;
import io.debezium.connector.mongodb.transforms.ExtractNewDocumentState;
import io.debezium.schema.FieldNameSelector;
import io.debezium.schema.SchemaNameAdjuster;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.data.Timestamp;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonType;
import org.bson.BsonValue;

public class MongoDataConverter {
    public static final String SCHEMA_NAME_REGEX = "io.debezium.mongodb.regex";
    private final ExtractNewDocumentState.ArrayEncoding arrayEncoding;
    private final FieldNameSelector.FieldNamer<String> fieldNamer;
    private final boolean sanitizeValue;

    public MongoDataConverter(ExtractNewDocumentState.ArrayEncoding arrayEncoding, FieldNameSelector.FieldNamer<String> fieldNamer, boolean sanitizeValue) {
        this.arrayEncoding = arrayEncoding;
        this.fieldNamer = fieldNamer;
        this.sanitizeValue = sanitizeValue;
    }

    public MongoDataConverter(ExtractNewDocumentState.ArrayEncoding arrayEncoding) {
        this(arrayEncoding, (FieldNameSelector.FieldNamer<String>)FieldNameSelector.defaultNonRelationalSelector((SchemaNameAdjuster)SchemaNameAdjuster.NO_OP), false);
    }

    public Map<String, Map<Object, BsonType>> parseBsonDocument(BsonDocument document) {
        if (document.isEmpty()) {
            return new LinkedHashMap<String, Map<Object, BsonType>>();
        }
        LinkedHashMap<String, Map<Object, BsonType>> schemaMap = new LinkedHashMap<String, Map<Object, BsonType>>();
        block4: for (Map.Entry entry : document.entrySet()) {
            String key = (String)entry.getKey();
            BsonValue value = (BsonValue)entry.getValue();
            BsonType type = value.getBsonType();
            switch (type) {
                case ARRAY: {
                    schemaMap.put(key, Map.of(this.traverseArray(value.asArray()), BsonType.ARRAY));
                    continue block4;
                }
                case DOCUMENT: {
                    schemaMap.put(key, Map.of(this.parseBsonDocument(value.asDocument()), BsonType.DOCUMENT));
                    continue block4;
                }
            }
            schemaMap.put(key, Map.of(value, type));
        }
        return schemaMap;
    }

    public Map<Object, BsonType> traverseArray(BsonArray array) {
        LinkedHashMap<Object, BsonType> unifiedSchema = new LinkedHashMap<Object, BsonType>();
        ArrayList<BsonValue> arrayElementList = new ArrayList<BsonValue>();
        LinkedHashMap<String, Set<Schema>> fieldSchemas = new LinkedHashMap<String, Set<Schema>>();
        LinkedHashMap<String, Map<Object, BsonType>> mergedDocumentSchema = new LinkedHashMap<String, Map<Object, BsonType>>();
        block8: for (BsonValue value : array) {
            BsonType bsonType = value.getBsonType();
            switch (bsonType) {
                case ARRAY: {
                    unifiedSchema.put(this.traverseArray(value.asArray()), BsonType.ARRAY);
                    continue block8;
                }
                case DOCUMENT: {
                    Map<String, Map<Object, BsonType>> documentSchema = this.parseBsonDocument(value.asDocument());
                    switch (this.arrayEncoding) {
                        case ARRAY: {
                            this.mergeSchemas(mergedDocumentSchema, documentSchema, fieldSchemas);
                            break;
                        }
                        case DOCUMENT: {
                            unifiedSchema.put(documentSchema, BsonType.DOCUMENT);
                        }
                    }
                    continue block8;
                }
            }
            arrayElementList.add(value);
        }
        if (this.arrayEncoding == ExtractNewDocumentState.ArrayEncoding.ARRAY && !mergedDocumentSchema.isEmpty()) {
            unifiedSchema.put(mergedDocumentSchema, BsonType.DOCUMENT);
        } else if (!arrayElementList.isEmpty()) {
            LinkedHashSet<BsonType> types = new LinkedHashSet<BsonType>();
            for (Object e : arrayElementList) {
                if (!(e instanceof BsonValue)) continue;
                types.add(((BsonValue)e).getBsonType());
            }
            unifiedSchema.put(arrayElementList, types.size() == 1 ? (BsonType)types.iterator().next() : BsonType.ARRAY);
        }
        return unifiedSchema;
    }

    private boolean isNestedMapObject(Object value) {
        return value instanceof Map && !((Map)value).isEmpty();
    }

    private boolean isEmptyNestedMapObject(Object value) {
        return value instanceof Map && ((Map)value).isEmpty();
    }

    private boolean isNestedListObject(Object value) {
        return value instanceof List && !((List)value).isEmpty();
    }

    private boolean isSameType(Object value, BsonType type) {
        return Objects.equals(value, type);
    }

    private void mergeSchemas(Map<String, Map<Object, BsonType>> baseDocument, Map<String, Map<Object, BsonType>> subDocument, Map<String, Set<Schema>> fieldSchemas) {
        for (Map.Entry<String, Map<Object, BsonType>> entry : subDocument.entrySet()) {
            String field = entry.getKey();
            Map<Object, BsonType> newValue = entry.getValue();
            BsonType type = newValue.values().iterator().next();
            Schema schema = this.getSchema(type);
            Object value = newValue.keySet().iterator().next();
            fieldSchemas.computeIfAbsent(field, k -> new LinkedHashSet()).add(schema);
            if (this.isNestedMapObject(value) && type == BsonType.DOCUMENT) {
                baseDocument.merge(field, new LinkedHashMap<Object, BsonType>(newValue), (existing, incoming) -> existing.equals(value) ? existing : incoming);
                continue;
            }
            if (fieldSchemas.get(field).size() > 1) {
                throw new DebeziumException("Array elements with different Bson types are not supported: " + String.valueOf(fieldSchemas));
            }
            baseDocument.put(field, new LinkedHashMap<Object, BsonType>(newValue));
        }
    }

    public void buildSchema(Map<String, Map<Object, BsonType>> map, SchemaBuilder builder) {
        for (Map.Entry<String, Map<Object, BsonType>> entry : map.entrySet()) {
            String key = this.fieldNamer.fieldNameFor((Object)entry.getKey());
            for (Map.Entry<Object, BsonType> objectBsonTypeEntry : entry.getValue().entrySet()) {
                this.schema(key, objectBsonTypeEntry, builder);
            }
        }
    }

    public void schema(String key, Map.Entry<Object, BsonType> entry, SchemaBuilder builder) {
        if (builder.field(key) != null) {
            return;
        }
        Object obj = entry.getKey();
        BsonType type = entry.getValue();
        block0 : switch (type) {
            case NULL: 
            case STRING: 
            case JAVASCRIPT: 
            case OBJECT_ID: 
            case DECIMAL128: {
                builder.field(key, Schema.OPTIONAL_STRING_SCHEMA);
                break;
            }
            case DOUBLE: {
                builder.field(key, Schema.OPTIONAL_FLOAT64_SCHEMA);
                break;
            }
            case BINARY: {
                builder.field(key, Schema.OPTIONAL_BYTES_SCHEMA);
                break;
            }
            case INT32: {
                builder.field(key, Schema.OPTIONAL_INT32_SCHEMA);
                break;
            }
            case INT64: {
                builder.field(key, Schema.OPTIONAL_INT64_SCHEMA);
                break;
            }
            case DATE_TIME: 
            case TIMESTAMP: {
                builder.field(key, Timestamp.builder().optional().build());
                break;
            }
            case BOOLEAN: {
                builder.field(key, Schema.OPTIONAL_BOOLEAN_SCHEMA);
                break;
            }
            case JAVASCRIPT_WITH_SCOPE: {
                SchemaBuilder jsWithScope = SchemaBuilder.struct().name(builder.name() + "." + key);
                jsWithScope.field("code", Schema.OPTIONAL_STRING_SCHEMA);
                SchemaBuilder scope = SchemaBuilder.struct().name(jsWithScope.name() + "." + key + ".scope").optional();
                for (Map.Entry jwsDoc : ((Map)obj).entrySet()) {
                    String fieldName = this.fieldNamer.fieldNameFor((Object)jwsDoc.getKey().toString());
                    Object value = jwsDoc.getValue();
                    this.schema(fieldName, (Map.Entry)value, scope);
                }
                Schema scopeBuild = scope.build();
                jsWithScope.field("scope", scopeBuild).build();
                builder.field(key, (Schema)jsWithScope);
                break;
            }
            case REGULAR_EXPRESSION: {
                SchemaBuilder regexwop = SchemaBuilder.struct().name(SCHEMA_NAME_REGEX).optional();
                regexwop.field("regex", Schema.OPTIONAL_STRING_SCHEMA);
                regexwop.field("options", Schema.OPTIONAL_STRING_SCHEMA);
                builder.field(key, regexwop.build());
                break;
            }
            case DOCUMENT: {
                if (!(obj instanceof Map)) break;
                Map map = (Map)obj;
                if (map.isEmpty()) {
                    builder.field(key, SchemaBuilder.struct().optional().build());
                    break;
                }
                SchemaBuilder documentBuilder = SchemaBuilder.struct().name(builder.name() + "." + key).optional();
                for (Map.Entry doc : map.entrySet()) {
                    String fieldName = this.fieldNamer.fieldNameFor((Object)doc.getKey().toString());
                    Object value = doc.getValue();
                    if (!(value instanceof Map)) continue;
                    Map nestedMap = (Map)value;
                    for (Map.Entry<Object, BsonType> entry2 : nestedMap.entrySet()) {
                        this.schema(fieldName, entry2, documentBuilder);
                    }
                }
                builder.field(key, documentBuilder.build());
                break;
            }
            case ARRAY: {
                if (!this.isNestedMapObject(obj)) {
                    switch (this.arrayEncoding) {
                        case ARRAY: {
                            builder.field(key, SchemaBuilder.array((Schema)Schema.OPTIONAL_STRING_SCHEMA).optional().build());
                            break;
                        }
                        case DOCUMENT: {
                            builder.field(key, SchemaBuilder.struct().name(builder.name() + "." + key).optional().build());
                        }
                    }
                    break;
                }
                switch (this.arrayEncoding) {
                    case ARRAY: {
                        for (Map.Entry doc : ((Map)obj).entrySet()) {
                            Object object = doc.getKey();
                            if (object instanceof Map) {
                                Map map = (Map)object;
                                SchemaBuilder nestedBuilder = SchemaBuilder.struct().name(builder.name() + "." + key).optional();
                                this.handleNestedArray(key, map, builder, nestedBuilder, false);
                                continue;
                            }
                            if (!(object instanceof List)) continue;
                            List list = (List)object;
                            this.handleSimpleArray(key, list, builder, false);
                        }
                        break block0;
                    }
                    case DOCUMENT: {
                        SchemaBuilder documentBuilder = this.createDocumentBuilder(builder, key);
                        int fieldIndex = 0;
                        for (Map.Entry doc : ((Map)obj).entrySet()) {
                            Object object = doc.getKey();
                            if (this.isNestedListObject(object)) {
                                this.parseArrayLists(documentBuilder, (List)object);
                                continue;
                            }
                            if (!this.isNestedMapObject(object)) continue;
                            SchemaBuilder documentMapBuilder = SchemaBuilder.struct().name(documentBuilder.name() + "." + this.arrayElementStructName(fieldIndex)).optional();
                            this.parseMapLists(documentMapBuilder, documentBuilder, (Map)object, builder.name() + "." + key, fieldIndex);
                            if (documentMapBuilder.fields().isEmpty()) continue;
                            documentBuilder.field(this.arrayElementStructName(fieldIndex++), documentMapBuilder.build());
                        }
                        if (!documentBuilder.schema().name().equals(builder.schema().name())) {
                            builder.field(key, documentBuilder.build());
                            break;
                        }
                        for (Field field : documentBuilder.fields()) {
                            builder.field(field.name(), field.schema());
                        }
                    }
                }
                break;
            }
        }
    }

    private void parseMapLists(SchemaBuilder documentMapBuilder, SchemaBuilder documentBuilder, Map<?, ?> map, String parentKey, int fieldIndex) {
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            String entryKey = this.fieldNamer.fieldNameFor((Object)entry.getKey().toString());
            Object entryValue = entry.getValue();
            if (this.isNestedMapObject(entryValue)) {
                for (Map.Entry<Object, BsonType> entry2 : ((Map)entryValue).entrySet()) {
                    if (((Map)entryValue).size() == 1) {
                        if (this.isEmptyNestedMapObject(entry2.getKey()) && this.isSameType(entry2.getValue(), BsonType.ARRAY)) {
                            String arrayKey = this.fieldNamer.fieldNameFor((Object)(documentMapBuilder.name() + "." + entryKey));
                            documentMapBuilder.field(entryKey, SchemaBuilder.struct().name(arrayKey).optional().build());
                            continue;
                        }
                        if (this.isNestedMapObject(entry2.getKey()) && this.isSameType(entry2.getValue(), BsonType.ARRAY)) {
                            SchemaBuilder documentArrayBuilder = SchemaBuilder.struct().name(documentMapBuilder.name() + "." + entryKey).optional();
                            this.schema(entryKey, entry2, documentArrayBuilder);
                            documentMapBuilder.field(entryKey, documentArrayBuilder.build());
                            continue;
                        }
                        if (this.isNestedMapObject(entry2.getKey()) && this.isSameType(entry2.getValue(), BsonType.DOCUMENT)) {
                            this.schema(entryKey, entry2, documentMapBuilder);
                            continue;
                        }
                        BsonValue bsonValue = (BsonValue)entry2.getKey();
                        documentMapBuilder.field(entryKey, this.getSchema(bsonValue.getBsonType()));
                        continue;
                    }
                    SchemaBuilder documentElementBuilder = SchemaBuilder.struct().name(parentKey + "." + this.arrayElementStructName(fieldIndex)).optional();
                    this.schema(entryKey, entry2, documentElementBuilder);
                    documentBuilder.field(this.arrayElementStructName(fieldIndex++), documentElementBuilder.build());
                }
                continue;
            }
            if (!this.isNestedListObject(entry.getKey())) continue;
            this.parseArrayLists(documentMapBuilder, (List)entry.getKey());
        }
    }

    private void parseArrayLists(SchemaBuilder documentMapBuilder, List<?> list) {
        for (int index = 0; index < list.size(); ++index) {
            Object obj = list.get(index);
            if (!(obj instanceof BsonValue)) continue;
            BsonValue bsonValue = (BsonValue)obj;
            documentMapBuilder.field(this.arrayElementStructName(index), this.getSchema(bsonValue.getBsonType()));
        }
    }

    private SchemaBuilder createDocumentBuilder(SchemaBuilder parentBuilder, String key) {
        if (parentBuilder.name().endsWith(key)) {
            return SchemaBuilder.struct().name(parentBuilder.name()).optional();
        }
        return SchemaBuilder.struct().name(parentBuilder.name() + "." + key).optional();
    }

    private void handleNestedArray(String key, Map<?, ?> map, SchemaBuilder builder, SchemaBuilder nestedBuilder, boolean nested) {
        for (Map.Entry<?, ?> doc : map.entrySet()) {
            Object docKey = doc.getKey();
            Object docValue = doc.getValue();
            if (docKey instanceof List) {
                List list = (List)docKey;
                this.handleSimpleArray(key, list, builder, true);
                continue;
            }
            if (docKey instanceof Map) {
                Map nestedMap = (Map)docKey;
                if (docValue.equals(BsonType.ARRAY)) {
                    this.handleSimpleArray(key, new ArrayList(nestedMap.values()), builder, true);
                    continue;
                }
                if (!docValue.equals(BsonType.DOCUMENT)) continue;
                SchemaBuilder documentArrayBuilder = SchemaBuilder.struct().optional();
                this.handleNestedArray(key, nestedMap, builder, documentArrayBuilder, true);
                continue;
            }
            if (!(docValue instanceof Map)) continue;
            Map nestedMap = (Map)docValue;
            String docKeyString = this.fieldNamer.fieldNameFor((Object)docKey.toString());
            this.validateSingleTypeMap(nestedMap);
            if (nestedBuilder.field(docKeyString) == null && !nestedMap.isEmpty()) {
                this.schema(docKeyString, nestedMap.entrySet().iterator().next(), nestedBuilder);
                continue;
            }
            for (Map.Entry<Object, BsonType> entry : nestedMap.entrySet()) {
                this.schema(docKeyString, entry, nestedBuilder);
            }
        }
        if (!nestedBuilder.fields().isEmpty() && builder.field(key) == null) {
            if (nested) {
                builder.field(key, SchemaBuilder.array((Schema)SchemaBuilder.array((Schema)nestedBuilder.build()).optional().build()).optional().build());
            } else {
                builder.field(key, SchemaBuilder.array((Schema)nestedBuilder.build()).optional().build());
            }
        }
    }

    private void handleSimpleArray(String key, List<?> list, SchemaBuilder builder, boolean nested) {
        if (builder.field(key) != null) {
            return;
        }
        BsonType elementType = this.validateSingleTypeArray(list);
        SchemaBuilder arraySchema = SchemaBuilder.array((Schema)this.getSchema(elementType)).optional();
        builder.field(key, nested ? SchemaBuilder.array((Schema)arraySchema.optional().build()).optional().build() : arraySchema.build());
    }

    private BsonType validateSingleTypeArray(List<?> list) {
        List<Schema> types = list.stream().map(o -> this.getSchema(((BsonValue)o).getBsonType())).distinct().toList();
        if (types.size() > 1) {
            throw new DebeziumException("Array elements with different Bson types are not supported: " + String.valueOf(list));
        }
        return ((BsonValue)list.get(0)).getBsonType();
    }

    private void validateSingleTypeMap(Map<?, ?> map) {
        List<Schema> types = map.values().stream().map(o -> this.getSchema((BsonType)o)).distinct().toList();
        if (types.size() > 1) {
            throw new DebeziumException("Array elements with different Bson types are not supported: " + String.valueOf(map));
        }
        map.values().iterator().next();
    }

    public Schema getSchema(BsonType type) {
        switch (type) {
            case NULL: 
            case STRING: 
            case JAVASCRIPT: 
            case OBJECT_ID: 
            case DECIMAL128: {
                return Schema.OPTIONAL_STRING_SCHEMA;
            }
            case DOUBLE: {
                return Schema.OPTIONAL_FLOAT64_SCHEMA;
            }
            case BINARY: {
                return Schema.OPTIONAL_BYTES_SCHEMA;
            }
            case INT32: {
                return Schema.OPTIONAL_INT32_SCHEMA;
            }
            case INT64: {
                return Schema.OPTIONAL_INT64_SCHEMA;
            }
            case DATE_TIME: 
            case TIMESTAMP: {
                return Timestamp.builder().optional().build();
            }
            case BOOLEAN: {
                return Schema.OPTIONAL_BOOLEAN_SCHEMA;
            }
            case ARRAY: {
                switch (this.arrayEncoding) {
                    case ARRAY: {
                        return SchemaBuilder.array((Schema)Schema.OPTIONAL_STRING_SCHEMA).optional().build();
                    }
                    case DOCUMENT: {
                        return SchemaBuilder.struct().optional().build();
                    }
                }
            }
            case DOCUMENT: {
                return SchemaBuilder.struct().optional().build();
            }
        }
        throw new IllegalArgumentException("The value type " + String.valueOf(type) + " is not supported for sub schema");
    }

    public void buildStruct(Map.Entry<String, BsonValue> bsonValueEntry, Schema schema, Struct struct) {
        Object colValue = null;
        String key = this.fieldNamer.fieldNameFor((Object)bsonValueEntry.getKey());
        BsonValue value = bsonValueEntry.getValue();
        BsonType type = value.getBsonType();
        switch (type) {
            case JAVASCRIPT_WITH_SCOPE: {
                Struct jsStruct = new Struct(schema.field(key).schema());
                Struct jsScopeStruct = new Struct(schema.field(key).schema().field("scope").schema());
                jsStruct.put("code", (Object)value.asJavaScriptWithScope().getCode());
                BsonDocument jwsDoc = value.asJavaScriptWithScope().getScope().asDocument();
                for (Map.Entry entry : jwsDoc.entrySet()) {
                    this.buildStruct(entry, schema.field(key).schema().field(key).schema(), jsScopeStruct);
                }
                jsStruct.put("scope", (Object)jsScopeStruct);
                colValue = jsStruct;
                break;
            }
            case REGULAR_EXPRESSION: {
                Struct regexStruct = new Struct(schema.field(key).schema());
                regexStruct.put("regex", (Object)value.asRegularExpression().getPattern());
                regexStruct.put("options", (Object)value.asRegularExpression().getOptions());
                colValue = regexStruct;
                break;
            }
            case ARRAY: {
                if (value.asArray().isEmpty()) {
                    if (this.sanitizeValue) {
                        return;
                    }
                    switch (this.arrayEncoding) {
                        case ARRAY: {
                            colValue = new ArrayList();
                            break;
                        }
                        case DOCUMENT: {
                            Schema fieldSchema = schema.field(key).schema();
                            colValue = new Struct(fieldSchema);
                        }
                    }
                    break;
                }
                switch (this.arrayEncoding) {
                    case ARRAY: {
                        Schema arraySchema = schema.field(key).schema().type() == Schema.Type.ARRAY ? schema.field(key).schema().valueSchema() : schema.field(key).schema();
                        colValue = this.buildArray(value.asArray(), arraySchema, new ArrayList<Object>());
                        break;
                    }
                    case DOCUMENT: {
                        BsonArray array = value.asArray();
                        HashMap<String, BsonValue> convertedArray = new HashMap<String, BsonValue>();
                        Schema arraySchemaForDocument = schema.field(key).schema();
                        Struct arrayStruct = new Struct(arraySchemaForDocument);
                        for (int i = 0; i < array.size(); ++i) {
                            convertedArray.put(this.arrayElementStructName(i), array.get(i));
                        }
                        for (Map.Entry<String, BsonValue> entry : convertedArray.entrySet()) {
                            this.buildStruct(entry, arraySchemaForDocument, arrayStruct);
                        }
                        colValue = arrayStruct;
                    }
                }
                break;
            }
            case DOCUMENT: {
                Field field = schema.field(key);
                if (field == null) {
                    throw new DebeziumException("Can't find field: " + key + " in schema " + String.valueOf(schema));
                }
                Schema documentSchema = field.schema();
                Struct documentStruct = new Struct(documentSchema);
                BsonDocument doc = value.asDocument();
                for (Map.Entry entry : doc.entrySet()) {
                    this.buildStruct(entry, documentSchema, documentStruct);
                }
                colValue = documentStruct;
                break;
            }
            default: {
                colValue = this.getObject(value);
            }
        }
        if (type != BsonType.UNDEFINED) {
            struct.put(key, colValue);
        }
    }

    protected String arrayElementStructName(int i) {
        return "_" + i;
    }

    private Object getObject(BsonValue value) {
        BsonType type = value.getBsonType();
        Object colValue = null;
        switch (type) {
            case STRING: {
                colValue = value.asString().getValue();
                break;
            }
            case OBJECT_ID: {
                colValue = value.asObjectId().getValue().toString();
                break;
            }
            case DECIMAL128: {
                colValue = value.asDecimal128().getValue().toString();
                break;
            }
            case DOUBLE: {
                colValue = value.asDouble().getValue();
                break;
            }
            case BINARY: {
                colValue = value.asBinary().getData();
                break;
            }
            case INT32: {
                colValue = value.asInt32().getValue();
                break;
            }
            case INT64: {
                colValue = value.asInt64().getValue();
                break;
            }
            case BOOLEAN: {
                colValue = value.asBoolean().getValue();
                break;
            }
            case DATE_TIME: {
                colValue = new Date(value.asDateTime().getValue());
                break;
            }
            case TIMESTAMP: {
                colValue = new Date(1000L * (long)value.asTimestamp().getTime());
                break;
            }
            case JAVASCRIPT: {
                colValue = value.asJavaScript().getCode();
                break;
            }
        }
        return colValue;
    }

    private Object buildArray(BsonArray array, Schema schema, ArrayList<Object> values) {
        block8: for (BsonValue value : array) {
            BsonType type = value.getBsonType();
            switch (type) {
                case ARRAY: {
                    ArrayList<Object> subValues = new ArrayList<Object>();
                    block9: for (BsonValue arrayValue : value.asArray()) {
                        BsonType valueBsonType = arrayValue.getBsonType();
                        switch (valueBsonType) {
                            case ARRAY: {
                                subValues.add(this.buildArray(arrayValue.asArray(), schema, new ArrayList<Object>()));
                                continue block9;
                            }
                            case DOCUMENT: {
                                BsonDocument doc = arrayValue.asDocument();
                                Struct struct = new Struct(schema.valueSchema());
                                for (Map.Entry entry : doc.entrySet()) {
                                    this.buildStruct(entry, schema.valueSchema(), struct);
                                }
                                subValues.add(struct);
                                continue block9;
                            }
                        }
                        subValues.add(this.getObject(arrayValue));
                    }
                    if (subValues.isEmpty()) continue block8;
                    values.add(subValues);
                    continue block8;
                }
                case DOCUMENT: {
                    BsonDocument doc = value.asDocument();
                    Struct struct = new Struct(schema);
                    for (Map.Entry entry : doc.entrySet()) {
                        this.buildStruct(entry, schema, struct);
                    }
                    values.add(struct);
                    continue block8;
                }
            }
            values.add(this.getObject(value));
        }
        return values;
    }
}

