/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.mysql.GtidSet;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.util.Strings;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.connect.errors.ConnectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySqlJdbcContext
implements AutoCloseable {
    protected static final String MYSQL_CONNECTION_URL = "jdbc:mysql://${hostname}:${port}/?useInformationSchema=true&nullCatalogMeansCurrent=false&useSSL=${useSSL}&useUnicode=true&characterEncoding=UTF-8&characterSetResults=UTF-8&zeroDateTimeBehavior=CONVERT_TO_NULL&connectTimeout=${connectTimeout}";
    protected static final String JDBC_PROPERTY_LEGACY_DATETIME = "useLegacyDatetimeCode";
    private static final String SQL_SHOW_SYSTEM_VARIABLES = "SHOW VARIABLES";
    private static final String SQL_SHOW_SYSTEM_VARIABLES_CHARACTER_SET = "SHOW VARIABLES WHERE Variable_name IN ('character_set_server','collation_server')";
    private static final String SQL_SHOW_SESSION_VARIABLE_SSL_VERSION = "SHOW SESSION STATUS LIKE 'Ssl_version'";
    protected static JdbcConnection.ConnectionFactory FACTORY = JdbcConnection.patternBasedFactory((String)"jdbc:mysql://${hostname}:${port}/?useInformationSchema=true&nullCatalogMeansCurrent=false&useSSL=${useSSL}&useUnicode=true&characterEncoding=UTF-8&characterSetResults=UTF-8&zeroDateTimeBehavior=CONVERT_TO_NULL&connectTimeout=${connectTimeout}", (Field[])new Field[0]);
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final Configuration config;
    protected final JdbcConnection jdbc;
    private final Map<String, String> originalSystemProperties = new HashMap<String, String>();

    public MySqlJdbcContext(MySqlConnectorConfig config) {
        this.config = config.getConfig();
        boolean useSSL = this.sslModeEnabled();
        Configuration jdbcConfig = this.config.filter(x -> !x.startsWith("database.history.") && !x.equals(MySqlConnectorConfig.DATABASE_HISTORY.name())).subset("database.", true);
        Configuration.Builder jdbcConfigBuilder = jdbcConfig.edit().with("connectTimeout", Long.toString(config.getConnectionTimeout().toMillis())).with("useSSL", Boolean.toString(useSSL));
        String legacyDateTime = jdbcConfig.getString(JDBC_PROPERTY_LEGACY_DATETIME);
        if (legacyDateTime == null) {
            jdbcConfigBuilder.with(JDBC_PROPERTY_LEGACY_DATETIME, "false");
        } else if ("true".equals(legacyDateTime)) {
            this.logger.warn("'{}' is set to 'true'. This setting is not recommended and can result in timezone issues.", (Object)JDBC_PROPERTY_LEGACY_DATETIME);
        }
        jdbcConfig = jdbcConfigBuilder.build();
        String driverClassName = jdbcConfig.getString(MySqlConnectorConfig.JDBC_DRIVER);
        this.jdbc = new JdbcConnection(jdbcConfig, JdbcConnection.patternBasedFactory((String)MYSQL_CONNECTION_URL, (String)driverClassName, (ClassLoader)this.getClass().getClassLoader(), (Field[])new Field[0]));
    }

    public Configuration config() {
        return this.config;
    }

    public JdbcConnection jdbc() {
        return this.jdbc;
    }

    public Logger logger() {
        return this.logger;
    }

    public String username() {
        return this.config.getString(MySqlConnectorConfig.USER);
    }

    public String password() {
        return this.config.getString(MySqlConnectorConfig.PASSWORD);
    }

    public String hostname() {
        return this.config.getString(MySqlConnectorConfig.HOSTNAME);
    }

    public int port() {
        return this.config.getInteger(MySqlConnectorConfig.PORT);
    }

    public MySqlConnectorConfig.SecureConnectionMode sslMode() {
        String mode = this.config.getString(MySqlConnectorConfig.SSL_MODE);
        return MySqlConnectorConfig.SecureConnectionMode.parse(mode);
    }

    public boolean sslModeEnabled() {
        return this.sslMode() != MySqlConnectorConfig.SecureConnectionMode.DISABLED;
    }

    public MySqlConnectorConfig.EventProcessingFailureHandlingMode eventDeserializationFailureHandlingMode() {
        String mode = this.config.getString(MySqlConnectorConfig.EVENT_DESERIALIZATION_FAILURE_HANDLING_MODE);
        return MySqlConnectorConfig.EventProcessingFailureHandlingMode.parse(mode);
    }

    public MySqlConnectorConfig.EventProcessingFailureHandlingMode inconsistentSchemaHandlingMode() {
        String mode = this.config.getString(MySqlConnectorConfig.INCONSISTENT_SCHEMA_HANDLING_MODE);
        return MySqlConnectorConfig.EventProcessingFailureHandlingMode.parse(mode);
    }

    public void start() {
        if (this.sslModeEnabled()) {
            this.originalSystemProperties.clear();
            this.setSystemProperty("javax.net.ssl.keyStore", MySqlConnectorConfig.SSL_KEYSTORE, true);
            this.setSystemProperty("javax.net.ssl.keyStorePassword", MySqlConnectorConfig.SSL_KEYSTORE_PASSWORD, false);
            this.setSystemProperty("javax.net.ssl.trustStore", MySqlConnectorConfig.SSL_TRUSTSTORE, true);
            this.setSystemProperty("javax.net.ssl.trustStorePassword", MySqlConnectorConfig.SSL_TRUSTSTORE_PASSWORD, false);
        }
    }

    public void shutdown() {
        try {
            this.jdbc.close();
        }
        catch (SQLException e) {
            this.logger.error("Unexpected error shutting down the database connection", (Throwable)e);
        }
        finally {
            this.originalSystemProperties.forEach((name, value) -> {
                if (value != null) {
                    System.setProperty(name, value);
                } else {
                    System.clearProperty(name);
                }
            });
        }
    }

    @Override
    public void close() {
        this.shutdown();
    }

    public boolean isGtidModeEnabled() {
        AtomicReference<String> mode = new AtomicReference<String>("off");
        try {
            this.jdbc().query("SHOW GLOBAL VARIABLES LIKE 'GTID_MODE'", rs -> {
                if (rs.next()) {
                    mode.set(rs.getString(2));
                }
            });
        }
        catch (SQLException e) {
            throw new ConnectException("Unexpected error while connecting to MySQL and looking at GTID mode: ", (Throwable)e);
        }
        return !"OFF".equalsIgnoreCase(mode.get());
    }

    public String knownGtidSet() {
        AtomicReference gtidSetStr = new AtomicReference();
        try {
            this.jdbc.query("SHOW MASTER STATUS", rs -> {
                if (rs.next() && rs.getMetaData().getColumnCount() > 4) {
                    gtidSetStr.set(rs.getString(5));
                }
            });
        }
        catch (SQLException e) {
            throw new ConnectException("Unexpected error while connecting to MySQL and looking at GTID mode: ", (Throwable)e);
        }
        String result = (String)gtidSetStr.get();
        return result != null ? result : "";
    }

    public GtidSet subtractGtidSet(GtidSet set1, GtidSet set2) {
        try {
            return (GtidSet)this.jdbc.prepareQueryAndMap("SELECT GTID_SUBTRACT(?, ?)", ps -> {
                ps.setString(1, set1.toString());
                ps.setString(2, set2.toString());
            }, rs -> {
                if (rs.next()) {
                    return new GtidSet(rs.getString(1));
                }
                return new GtidSet("");
            });
        }
        catch (SQLException e) {
            throw new ConnectException("Unexpected error while connecting to MySQL and looking at GTID mode: ", (Throwable)e);
        }
    }

    public GtidSet purgedGtidSet() {
        AtomicReference gtidSetStr = new AtomicReference();
        try {
            this.jdbc.query("SELECT @@global.gtid_purged", rs -> {
                if (rs.next() && rs.getMetaData().getColumnCount() > 0) {
                    gtidSetStr.set(rs.getString(1));
                }
            });
        }
        catch (SQLException e) {
            throw new ConnectException("Unexpected error while connecting to MySQL and looking at gtid_purged variable: ", (Throwable)e);
        }
        String result = (String)gtidSetStr.get();
        if (result == null) {
            result = "";
        }
        return new GtidSet(result);
    }

    public boolean userHasPrivileges(String grantName) {
        AtomicBoolean result = new AtomicBoolean(false);
        try {
            this.jdbc.query("SHOW GRANTS FOR CURRENT_USER", rs -> {
                while (rs.next()) {
                    String grants = rs.getString(1);
                    this.logger.debug(grants);
                    if (grants == null) {
                        return;
                    }
                    if (!(grants = grants.toUpperCase()).contains("ALL") && !grants.contains(grantName.toUpperCase())) continue;
                    result.set(true);
                }
            });
        }
        catch (SQLException e) {
            throw new ConnectException("Unexpected error while connecting to MySQL and looking at privileges for current user: ", (Throwable)e);
        }
        return result.get();
    }

    protected String connectionString() {
        return this.jdbc.connectionString(MYSQL_CONNECTION_URL);
    }

    protected Map<String, String> readMySqlCharsetSystemVariables() {
        this.logger.debug("Reading MySQL charset-related system variables before parsing DDL history.");
        return this.querySystemVariables(SQL_SHOW_SYSTEM_VARIABLES_CHARACTER_SET);
    }

    protected Map<String, String> readMySqlSystemVariables() {
        this.logger.debug("Reading MySQL system variables");
        return this.querySystemVariables(SQL_SHOW_SYSTEM_VARIABLES);
    }

    private Map<String, String> querySystemVariables(String statement) {
        HashMap<String, String> variables = new HashMap<String, String>();
        try {
            this.start();
            this.jdbc.connect().query(statement, rs -> {
                while (rs.next()) {
                    String varName = rs.getString(1);
                    String value = rs.getString(2);
                    if (varName == null || value == null) continue;
                    variables.put(varName, value);
                    this.logger.debug("\t{} = {}", (Object)Strings.pad((String)varName, (int)45, (char)' '), (Object)Strings.pad((String)value, (int)45, (char)' '));
                }
            });
        }
        catch (SQLException e) {
            throw new ConnectException("Error reading MySQL variables: " + e.getMessage(), (Throwable)e);
        }
        return variables;
    }

    protected String setStatementFor(Map<String, String> variables) {
        StringBuilder sb = new StringBuilder("SET ");
        boolean first = true;
        ArrayList<String> varNames = new ArrayList<String>(variables.keySet());
        Collections.sort(varNames);
        for (String varName : varNames) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(varName).append("=");
            String value = variables.get(varName);
            if (value == null) {
                value = "";
            }
            if (value.contains(",") || value.contains(";")) {
                value = "'" + value + "'";
            }
            sb.append(value);
        }
        return sb.append(";").toString();
    }

    protected void setSystemProperty(String property, Field field, boolean showValueInError) {
        String value = this.config.getString(field);
        if (value != null) {
            value = value.trim();
            String existingValue = System.getProperty(property);
            if (existingValue == null) {
                String existing = System.setProperty(property, value);
                this.originalSystemProperties.put(property, existing);
            } else if (!(existingValue = existingValue.trim()).equalsIgnoreCase(value)) {
                String msg = "System or JVM property '" + property + "' is already defined, but the configuration property '" + field.name() + "' defines a different value";
                if (showValueInError) {
                    msg = "System or JVM property '" + property + "' is already defined as " + existingValue + ", but the configuration property '" + field.name() + "' defines a different value '" + value + "'";
                }
                throw new ConnectException(msg);
            }
        }
    }

    protected String getSessionVariableForSslVersion() {
        String SSL_VERSION = "Ssl_version";
        this.logger.debug("Reading MySQL Session variable for Ssl Version");
        Map<String, String> sessionVariables = this.querySystemVariables(SQL_SHOW_SESSION_VARIABLE_SSL_VERSION);
        if (!sessionVariables.isEmpty() && sessionVariables.containsKey("Ssl_version")) {
            return sessionVariables.get("Ssl_version");
        }
        return null;
    }
}

