/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.connector.mysql.MySqlTestConnection;
import io.debezium.connector.mysql.UniqueDatabase;
import io.debezium.junit.EqualityCheck;
import io.debezium.junit.SkipTestRule;
import io.debezium.junit.SkipWhenDatabaseVersion;
import io.debezium.util.Testing;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;

@SkipWhenDatabaseVersion(check=EqualityCheck.LESS_THAN, major=5, minor=6, patch=5, reason="MySQL 5.5 does not support CURRENT_TIMESTAMP on DATETIME and only a single column can specify default CURRENT_TIMESTAMP, lifted in MySQL 5.6.5")
public class ConnectionIT
implements Testing {
    @Rule
    public SkipTestRule skipTest = new SkipTestRule();

    @Ignore
    @Test
    public void shouldConnectToDefaultDatabase() throws SQLException {
        try (MySqlTestConnection conn = MySqlTestConnection.forTestDatabase("mysql");){
            conn.connect();
        }
    }

    @Test
    public void shouldDoStuffWithDatabase() throws SQLException {
        UniqueDatabase DATABASE = new UniqueDatabase("readbinlog", "readbinlog_test");
        DATABASE.createAndInitialize();
        try (MySqlTestConnection conn = MySqlTestConnection.forTestDatabase(DATABASE.getDatabaseName());){
            conn.connect();
            conn.execute(new String[]{"DROP TABLE IF EXISTS person", "CREATE TABLE person (  name VARCHAR(255) primary key,  birthdate DATE NULL,  age INTEGER NULL DEFAULT 10,  salary DECIMAL(5,2),  bitStr BIT(18))"});
            conn.execute(new String[]{"SELECT * FROM person"});
            ResultSet rs = conn.connection().getMetaData().getColumns("readbinlog_test", null, null, null);
            if (rs != null) {
                rs.close();
            }
        }
    }

    @Ignore
    @Test
    public void shouldConnectToEmptyDatabase() throws SQLException {
        try (MySqlTestConnection conn = MySqlTestConnection.forTestDatabase("emptydb");){
            conn.connect();
        }
    }
}

