/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.mysql.MySqlConnector;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.UniqueDatabase;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.junit.EqualityCheck;
import io.debezium.junit.SkipWhenDatabaseVersion;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.apache.kafka.connect.data.Struct;
import org.fest.assertions.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@SkipWhenDatabaseVersion(check=EqualityCheck.LESS_THAN, major=5, minor=7, reason="JSON data type was not added until MySQL 5.7")
public class MySqlConnectorJsonIT
extends AbstractConnectorTest {
    private static final Path DB_HISTORY_PATH = Testing.Files.createTestingPath((String)"file-db-history-json.txt").toAbsolutePath();
    private final UniqueDatabase DATABASE = new UniqueDatabase("jsonit", "json_test").withDbHistoryPath(DB_HISTORY_PATH);
    private Configuration config;

    @Before
    public void beforeEach() {
        this.stopConnector();
        this.DATABASE.createAndInitialize();
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)DB_HISTORY_PATH);
    }

    @After
    public void afterEach() {
        try {
            this.stopConnector();
        }
        finally {
            Testing.Files.delete((Path)DB_HISTORY_PATH);
        }
    }

    @Test
    @FixFor(value={"DBZ-126"})
    public void shouldConsumeAllEventsFromDatabaseUsingBinlogAndNoSnapshot() throws SQLException, InterruptedException {
        this.config = ((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.NEVER)).build();
        this.start(MySqlConnector.class, this.config);
        int numCreateDatabase = 1;
        int numCreateTables = 1;
        int numDataRecords = 1;
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(numCreateDatabase + numCreateTables + numDataRecords);
        this.stopConnector();
        Assertions.assertThat((Object)records).isNotNull();
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.getServerName()).size()).isEqualTo(numCreateDatabase + numCreateTables);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("dbz_126_jsontable")).size()).isEqualTo(1);
        Assertions.assertThat((int)records.topics().size()).isEqualTo(1 + numCreateTables);
        Assertions.assertThat((int)records.databaseNames().size()).isEqualTo(1);
        Assertions.assertThat((int)records.ddlRecordsForDatabase(this.DATABASE.getDatabaseName()).size()).isEqualTo(numCreateDatabase + numCreateTables);
        Assertions.assertThat((List)records.ddlRecordsForDatabase("regression_test")).isNull();
        Assertions.assertThat((List)records.ddlRecordsForDatabase("connector_test")).isNull();
        Assertions.assertThat((List)records.ddlRecordsForDatabase("readbinlog_test")).isNull();
        records.ddlRecordsForDatabase(this.DATABASE.getDatabaseName()).forEach(arg_0 -> ((MySqlConnectorJsonIT)this).print(arg_0));
        records.forEach(arg_0 -> ((MySqlConnectorJsonIT)this).validate(arg_0));
        ArrayList errors = new ArrayList();
        records.forEach(record -> {
            Struct value = (Struct)record.value();
            if (record.topic().endsWith("dbz_126_jsontable")) {
                Struct after = value.getStruct("after");
                Integer i = after.getInt32("id");
                Assertions.assertThat((Integer)i).isNotNull();
                String json = after.getString("json");
                String expectedBinlog = after.getString("expectedBinlogStr");
                this.check(json, expectedBinlog, errors::add);
            }
        });
        if (!errors.isEmpty()) {
            Assert.fail((String)("" + errors.size() + " errors with JSON records..." + System.lineSeparator() + String.join((CharSequence)System.lineSeparator(), errors)));
        }
    }

    @Test
    public void shouldConsumeAllEventsFromDatabaseUsingSnapshot() throws SQLException, InterruptedException {
        this.config = this.DATABASE.defaultConfig().build();
        this.start(MySqlConnector.class, this.config);
        int numTables = 1;
        int numDataRecords = 1;
        int numDdlRecords = numTables * 2 + 3;
        int numSetVariables = 1;
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(numDdlRecords + numSetVariables + numDataRecords);
        this.stopConnector();
        Assertions.assertThat((Object)records).isNotNull();
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.getServerName()).size()).isEqualTo(numDdlRecords + numSetVariables);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("dbz_126_jsontable")).size()).isEqualTo(1);
        Assertions.assertThat((int)records.topics().size()).isEqualTo(numTables + 1);
        Assertions.assertThat((int)records.databaseNames().size()).isEqualTo(2);
        Assertions.assertThat((Collection)records.databaseNames()).containsOnly(new Object[]{this.DATABASE.getDatabaseName(), ""});
        Assertions.assertThat((int)records.ddlRecordsForDatabase(this.DATABASE.getDatabaseName()).size()).isEqualTo(numDdlRecords);
        Assertions.assertThat((List)records.ddlRecordsForDatabase("regression_test")).isNull();
        Assertions.assertThat((List)records.ddlRecordsForDatabase("connector_test")).isNull();
        Assertions.assertThat((List)records.ddlRecordsForDatabase("readbinlog_test")).isNull();
        Assertions.assertThat((int)records.ddlRecordsForDatabase("").size()).isEqualTo(1);
        records.ddlRecordsForDatabase(this.DATABASE.getDatabaseName()).forEach(arg_0 -> ((MySqlConnectorJsonIT)this).print(arg_0));
        records.forEach(arg_0 -> ((MySqlConnectorJsonIT)this).validate(arg_0));
        ArrayList errors = new ArrayList();
        records.forEach(record -> {
            Struct value = (Struct)record.value();
            if (record.topic().endsWith("dbz_126_jsontable")) {
                Struct after = value.getStruct("after");
                Integer i = after.getInt32("id");
                Assertions.assertThat((Integer)i).isNotNull();
                String json = after.getString("json");
                String expectedJdbc = after.getString("expectedJdbcStr");
                this.check(json, expectedJdbc, errors::add);
            }
        });
        if (!errors.isEmpty()) {
            Assert.fail((String)("" + errors.size() + " errors with JSON records..." + System.lineSeparator() + String.join((CharSequence)System.lineSeparator(), errors)));
        }
    }

    protected void check(String json, String expectedBinlog, Consumer<String> msg) {
        if (json == null && expectedBinlog != null || json != null && !json.equals(expectedBinlog)) {
            msg.accept("JSON was:     " + json + System.lineSeparator() + "but expected: " + expectedBinlog);
        } else {
            Assertions.assertThat((String)json).isEqualTo((Object)expectedBinlog);
        }
    }
}

