/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql.legacy;

import io.debezium.connector.mysql.legacy.Configurator;
import io.debezium.connector.mysql.legacy.Filters;
import io.debezium.doc.FixFor;
import io.debezium.relational.TableId;
import org.fest.assertions.Assertions;
import org.junit.Before;
import org.junit.Test;

public class FiltersTest {
    private Configurator build;
    private Filters filters;

    @Before
    public void beforeEach() {
        this.build = new Configurator();
        this.filters = null;
    }

    @Test
    public void shouldAllowDatabaseListedWithLiteralInWhitelistAndNoDatabaseBlacklist() {
        this.filters = this.build.includeDatabases("connector_test").createFilters();
        this.assertDatabaseIncluded("connector_test");
        this.assertDatabaseExcluded("other");
        this.assertSystemDatabasesExcluded();
    }

    @Test
    public void shouldAllowDatabaseListedWithMultipleLiteralsInWhitelistAndNoDatabaseBlacklist() {
        this.filters = this.build.includeDatabases("connector_test,another_included").createFilters();
        this.assertDatabaseIncluded("connector_test");
        this.assertDatabaseIncluded("another_included");
        this.assertDatabaseExcluded("other");
        this.assertSystemDatabasesExcluded();
    }

    @Test
    public void shouldAllowDatabaseListedWithMultipleRegexInWhitelistAndNoDatabaseBlacklist() {
        this.filters = this.build.includeDatabases("connector.*_test,another_{1}.*").createFilters();
        this.assertDatabaseIncluded("connector_test");
        this.assertDatabaseIncluded("another_included");
        this.assertDatabaseIncluded("another__test");
        this.assertDatabaseExcluded("conn_test");
        this.assertDatabaseExcluded("connector-test");
        this.assertDatabaseExcluded("other");
        this.assertSystemDatabasesExcluded();
    }

    @Test
    public void shouldAllowDatabaseListedWithWildcardInWhitelistAndNoDatabaseBlacklist() {
        this.filters = this.build.includeDatabases(".*").createFilters();
        this.assertDatabaseIncluded("connector_test");
        this.assertDatabaseIncluded("another_included");
        this.assertDatabaseIncluded("other");
        this.assertSystemDatabasesExcluded();
    }

    @Test
    public void shouldAllowAllDatabaseExceptSystemWhenWhitelistIsBlank() {
        this.filters = this.build.includeDatabases("").createFilters();
        this.assertDatabaseIncluded("connector_test");
        this.assertDatabaseIncluded("other");
        this.assertSystemDatabasesExcluded();
    }

    @Test
    public void shouldNotAllowDatabaseListedWithLiteralInBlacklistAndNoDatabaseWhitelist() {
        this.filters = this.build.excludeDatabases("connector_test").createFilters();
        this.assertDatabaseExcluded("connector_test");
        this.assertDatabaseIncluded("other");
        this.assertSystemDatabasesExcluded();
    }

    @Test
    public void shouldNotAllowDatabaseListedWithMultipleLiteralsInBlacklistAndNoDatabaseWhitelist() {
        this.filters = this.build.excludeDatabases("connector_test,another_included").createFilters();
        this.assertDatabaseExcluded("connector_test");
        this.assertDatabaseExcluded("another_included");
        this.assertDatabaseIncluded("other");
        this.assertDatabaseIncluded("something-else");
        this.assertSystemDatabasesExcluded();
    }

    @Test
    public void shouldNotAllowDatabaseListedWithMultipleRegexInBlacklistAndNoDatabaseWhitelist() {
        this.filters = this.build.excludeDatabases("connector.*_test,another_{1}.*").createFilters();
        this.assertDatabaseExcluded("connector_test");
        this.assertDatabaseExcluded("another_included");
        this.assertDatabaseExcluded("another__test");
        this.assertDatabaseIncluded("conn_test");
        this.assertDatabaseIncluded("connector-test");
        this.assertDatabaseIncluded("other");
        this.assertSystemDatabasesExcluded();
    }

    @Test
    public void shouldNotAllowDatabaseListedWithWildcardInBlacklistAndNoDatabaseWhitelist() {
        this.filters = this.build.excludeDatabases(".*").createFilters();
        this.assertDatabaseExcluded("connector_test");
        this.assertDatabaseExcluded("another_included");
        this.assertDatabaseExcluded("other");
        this.assertSystemDatabasesExcluded();
    }

    @Test
    public void shouldRespectOnlyDatabaseWhitelistWithDatabaseBlacklistAlsoSpecified() {
        this.filters = this.build.includeDatabases("A,B,C,D.*").excludeDatabases("C,B,E").createFilters();
        this.assertDatabaseIncluded("A");
        this.assertDatabaseIncluded("B");
        this.assertDatabaseIncluded("C");
        this.assertDatabaseIncluded("D");
        this.assertDatabaseIncluded("D1");
        this.assertDatabaseIncluded("D_3");
        this.assertDatabaseExcluded("E");
        this.assertDatabaseExcluded("another__test");
        this.assertSystemDatabasesExcluded();
    }

    @Test
    public void shouldAllowAllDatabaseWhenBlacklistIsBlank() {
        this.filters = this.build.excludeDatabases("").createFilters();
        this.assertDatabaseIncluded("connector_test");
        this.assertDatabaseIncluded("other");
        this.assertSystemDatabasesExcluded();
    }

    @Test
    public void shouldIgnoreDatabaseBlacklistWhenDatabaseWhitelistIsNonEmpty() {
        this.filters = this.build.includeDatabases(".*").excludeDatabases("connector_test,other").createFilters();
        this.assertDatabaseIncluded("connector_test");
        this.assertDatabaseIncluded("other");
        this.assertDatabaseIncluded("something_else");
        this.assertSystemDatabasesExcluded();
    }

    @Test
    public void shouldAllowTableListedWithLiteralInWhitelistAndNoTableBlacklistWhenDatabaseIncluded() {
        this.filters = this.build.includeTables("connector_test.table1").createFilters();
        this.assertTableIncluded("connector_test.table1");
        this.assertTableExcluded("connector_test.table2");
        this.assertTableExcluded("connector_test.table3");
        this.assertDatabaseIncluded("connector_test");
        this.assertDatabaseIncluded("other_test");
        this.assertSystemTablesExcluded();
        this.assertSystemDatabasesExcluded();
    }

    @Test
    public void shouldAllowTableListedWithLiteralWithEscapedPeriodInWhitelistAndNoTableBlacklistWhenDatabaseIncluded() {
        this.filters = this.build.includeTables("connector_test[.]table1").createFilters();
        this.assertTableIncluded("connector_test.table1");
        this.assertTableExcluded("connector_test.table2");
        this.assertTableExcluded("connector_test.table3");
        this.assertDatabaseIncluded("connector_test");
        this.assertDatabaseIncluded("other_test");
        this.assertSystemTablesExcluded();
        this.assertSystemDatabasesExcluded();
        this.filters = this.build.includeTables("connector_test\\.table1").createFilters();
        this.assertTableIncluded("connector_test.table1");
        this.assertTableExcluded("connector_test.table2");
        this.assertTableExcluded("connector_test.table3");
        this.assertDatabaseIncluded("connector_test");
        this.assertDatabaseIncluded("other_test");
        this.assertSystemTablesExcluded();
        this.assertSystemDatabasesExcluded();
    }

    @Test
    public void shouldAllowTableListedWithMultipleLiteralsInWhitelistAndNoTableBlacklistWhenDatabaseIncluded() {
        this.filters = this.build.includeTables("connector_test.table1,connector_test.table2").createFilters();
        this.assertTableIncluded("connector_test.table1");
        this.assertTableIncluded("connector_test.table2");
        this.assertTableExcluded("connector_test.table3");
        this.assertDatabaseIncluded("connector_test");
        this.assertDatabaseIncluded("other_test");
        this.assertSystemTablesExcluded();
        this.assertSystemDatabasesExcluded();
    }

    @Test
    @FixFor(value={"DBZ-1546"})
    public void shouldAllowTableListedWithWhitespaceCharactersInWhitelistAndNoTableBlacklistWhenDatabaseIncluded() {
        this.filters = this.build.includeTables("connector_test.table1, connector_test.table2").createFilters();
        this.assertTableIncluded("connector_test.table1");
        this.assertTableIncluded("connector_test.table2");
        this.assertTableExcluded("connector_test.table3");
    }

    @Test
    public void shouldAllowTableListedWithMultipleRegexInWhitelistAndNoTableBlacklistWhenDatabaseIncluded() {
        this.filters = this.build.includeTables("connector_test.table[x]?1,connector_test[.](.*)2").createFilters();
        this.assertTableIncluded("connector_test.table1");
        this.assertTableIncluded("connector_test.table2");
        this.assertTableExcluded("connector_test.table3");
        this.assertDatabaseIncluded("connector_test");
        this.assertDatabaseIncluded("other_test");
        this.assertSystemTablesExcluded();
        this.assertSystemDatabasesExcluded();
    }

    @Test
    public void shouldAllowTableListedWithWildcardInWhitelistAndNoTableBlacklistWhenDatabaseIncluded() {
        this.filters = this.build.includeTables("connector_test[.](.*)").createFilters();
        this.assertTableIncluded("connector_test.table1");
        this.assertTableIncluded("connector_test.table2");
        this.assertTableIncluded("connector_test.table3");
        this.assertTableIncluded("connector_test.ABC");
        this.assertDatabaseIncluded("connector_test");
        this.assertDatabaseIncluded("other_test");
        this.assertSystemTablesExcluded();
        this.assertSystemDatabasesExcluded();
    }

    @Test
    @FixFor(value={"DBZ-242"})
    public void shouldAllowTableListedWithLiteralInWhitelistAndNoTableBlacklistWhenDatabaseIncludedButSystemTablesExcluded() {
        this.filters = this.build.includeTables("connector_test.table1,connector_test.table2").includeBuiltInTables().createFilters();
        this.assertTableIncluded("connector_test.table1");
        this.assertTableIncluded("connector_test.table2");
        this.assertTableExcluded("connector_test.table3");
        this.assertTableExcluded("other.table1");
        this.assertDatabaseIncluded("connector_test");
        this.assertDatabaseIncluded("other_test");
        this.assertSystemTablesExcluded();
        this.assertSystemDatabasesIncluded();
    }

    @Test
    @FixFor(value={"DBZ-242"})
    public void shouldAllowTableListedWithLiteralInWhitelistAndTableWhitelistWhenDatabaseIncludedButSystemTablesIncluded() {
        this.filters = this.build.includeTables("connector_test.table1,connector_test.table2").includeDatabases("connector_test,mysql").includeBuiltInTables().createFilters();
        this.assertTableIncluded("connector_test.table1");
        this.assertTableIncluded("connector_test.table2");
        this.assertTableExcluded("connector_test.table3");
        this.assertTableExcluded("other.table1");
        this.assertDatabaseIncluded("connector_test");
        this.assertDatabaseExcluded("other_test");
        this.assertDatabaseIncluded("mysql");
        this.assertSystemTablesExcluded();
    }

    @Test
    @FixFor(value={"DBZ-242"})
    public void shouldAllowTableListedWithLiteralInWhitelistAndNoTableBlacklistWhenDatabaseIncludedButSystemTablesIncluded() {
        this.filters = this.build.includeTables("connector_test.table1,connector_test.table2,mysql[.].*,performance_schema[.].*,sys[.].*,information_schema[.].*").includeBuiltInTables().createFilters();
        this.assertTableIncluded("connector_test.table1");
        this.assertTableIncluded("connector_test.table2");
        this.assertTableExcluded("connector_test.table3");
        this.assertTableExcluded("other.table1");
        this.assertDatabaseIncluded("connector_test");
        this.assertDatabaseIncluded("other_test");
        this.assertSystemTablesIncluded();
        this.assertSystemDatabasesIncluded();
    }

    @Test
    public void shouldNotAllowTableWhenNotIncludedInDatabaseWhitelist() {
        this.filters = this.build.includeTables("db1.table1,db2.table1,db3.*").includeDatabases("db1,db3").createFilters();
        this.assertTableIncluded("db1.table1");
        this.assertTableExcluded("db1.table2");
        this.assertTableExcluded("db2.table1");
        this.assertTableExcluded("db2.table2");
        this.assertTableIncluded("db3.table1");
        this.assertTableIncluded("db3.table2");
        this.assertTableExcluded("db4.table1");
        this.assertTableExcluded("db4.table2");
        this.assertDatabaseIncluded("db1");
        this.assertDatabaseIncluded("db3");
        this.assertDatabaseExcluded("db2");
        this.assertSystemTablesExcluded();
        this.assertSystemDatabasesExcluded();
    }

    @Test
    public void shouldNotAllowTableWhenExcludedInDatabaseWhitelist() {
        this.filters = this.build.includeTables("db1.table1,db2.table1,db3.*").excludeDatabases("db2").createFilters();
        this.assertTableIncluded("db1.table1");
        this.assertTableExcluded("db1.table2");
        this.assertTableExcluded("db2.table1");
        this.assertTableExcluded("db2.table2");
        this.assertTableIncluded("db3.table1");
        this.assertTableIncluded("db3.table2");
        this.assertTableExcluded("db4.table1");
        this.assertTableExcluded("db4.table2");
        this.assertDatabaseIncluded("db1");
        this.assertDatabaseIncluded("db3");
        this.assertDatabaseExcluded("db2");
        this.assertSystemTablesExcluded();
        this.assertSystemDatabasesExcluded();
    }

    @Test
    @FixFor(value={"DBZ-1939"})
    public void shouldNotAllowIgnoredTable() {
        this.filters = this.build.includeBuiltInTables().createFilters();
        this.assertIgnoredTableExcluded("mysql.rds_configuration");
        this.assertNonIgnoredTableIncluded("mysql.table1");
    }

    protected void assertDatabaseIncluded(String databaseName) {
        Assertions.assertThat((boolean)this.filters.databaseFilter().test(databaseName)).isTrue();
    }

    protected void assertDatabaseExcluded(String databaseName) {
        Assertions.assertThat((boolean)this.filters.databaseFilter().test(databaseName)).isFalse();
    }

    protected void assertSystemDatabasesExcluded() {
        Filters.BUILT_IN_DB_NAMES.forEach(this::assertDatabaseExcluded);
    }

    protected void assertSystemDatabasesIncluded() {
        Filters.BUILT_IN_DB_NAMES.forEach(this::assertDatabaseIncluded);
    }

    protected void assertSystemTablesExcluded() {
        Filters.BUILT_IN_DB_NAMES.forEach(dbName -> this.assertTableExcluded(dbName + ".foo"));
    }

    protected void assertSystemTablesIncluded() {
        Filters.BUILT_IN_DB_NAMES.forEach(dbName -> this.assertTableIncluded(dbName + ".foo"));
    }

    protected void assertTableIncluded(String fullyQualifiedTableName) {
        TableId id = TableId.parse((String)fullyQualifiedTableName);
        Assertions.assertThat((boolean)this.filters.tableFilter().test(id)).isTrue();
    }

    protected void assertTableExcluded(String fullyQualifiedTableName) {
        TableId id = TableId.parse((String)fullyQualifiedTableName);
        Assertions.assertThat((boolean)this.filters.tableFilter().test(id)).isFalse();
    }

    protected void assertIgnoredTableExcluded(String fullyQualifiedTableName) {
        TableId id = TableId.parse((String)fullyQualifiedTableName);
        Assertions.assertThat((boolean)this.filters.tableFilter().test(id)).isFalse();
        Assertions.assertThat((boolean)this.filters.ignoredTableFilter().test(id)).isTrue();
    }

    protected void assertNonIgnoredTableIncluded(String fullyQualifiedTableName) {
        TableId id = TableId.parse((String)fullyQualifiedTableName);
        Assertions.assertThat((boolean)this.filters.tableFilter().test(id)).isTrue();
        Assertions.assertThat((boolean)this.filters.ignoredTableFilter().test(id)).isFalse();
    }
}

