/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.DebeziumException;
import io.debezium.connector.binlog.BinlogConnectorConfig;
import io.debezium.connector.binlog.BinlogDatabaseSchema;
import io.debezium.connector.binlog.BinlogSnapshotChangeEventSource;
import io.debezium.connector.binlog.jdbc.BinlogConnectorConnection;
import io.debezium.connector.binlog.metrics.BinlogSnapshotChangeEventSourceMetrics;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlDatabaseSchema;
import io.debezium.connector.mysql.MySqlOffsetContext;
import io.debezium.connector.mysql.MySqlPartition;
import io.debezium.connector.mysql.MySqlSnapshotChangeEventSourceMetrics;
import io.debezium.function.BlockingConsumer;
import io.debezium.jdbc.MainConnectionProvidingConnectionFactory;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.notification.NotificationService;
import io.debezium.relational.RelationalSnapshotChangeEventSource;
import io.debezium.relational.TableId;
import io.debezium.snapshot.SnapshotterService;
import io.debezium.util.Clock;
import java.util.function.Function;
import org.apache.kafka.connect.source.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySqlSnapshotChangeEventSource
extends BinlogSnapshotChangeEventSource<MySqlPartition, MySqlOffsetContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MySqlSnapshotChangeEventSource.class);
    private final MySqlConnectorConfig connectorConfig;

    public MySqlSnapshotChangeEventSource(MySqlConnectorConfig connectorConfig, MainConnectionProvidingConnectionFactory<BinlogConnectorConnection> connectionFactory, MySqlDatabaseSchema schema, EventDispatcher<MySqlPartition, TableId> dispatcher, Clock clock, MySqlSnapshotChangeEventSourceMetrics metrics, BlockingConsumer<Function<SourceRecord, SourceRecord>> lastEventProcessor, Runnable preSnapshotAction, NotificationService<MySqlPartition, MySqlOffsetContext> notificationService, SnapshotterService snapshotterService) {
        super((BinlogConnectorConfig)connectorConfig, connectionFactory, (BinlogDatabaseSchema)schema, dispatcher, clock, (BinlogSnapshotChangeEventSourceMetrics)metrics, lastEventProcessor, preSnapshotAction, notificationService, snapshotterService);
        this.connectorConfig = connectorConfig;
    }

    protected MySqlOffsetContext getInitialOffsetContext(BinlogConnectorConfig connectorConfig) {
        return MySqlOffsetContext.initial((MySqlConnectorConfig)connectorConfig);
    }

    protected void setOffsetContextBinlogPositionAndGtidDetailsForSnapshot(MySqlOffsetContext offsetContext, BinlogConnectorConnection connection, SnapshotterService snapshotterService) throws Exception {
        LOGGER.info("Read binlog position of MySQL primary server");
        String showMasterStmt = connection.binaryLogStatusStatement();
        connection.query(showMasterStmt, rs -> {
            if (rs.next()) {
                String binlogFilename = rs.getString(1);
                long binlogPosition = rs.getLong(2);
                offsetContext.setBinlogStartPoint(binlogFilename, binlogPosition);
                if (rs.getMetaData().getColumnCount() > 4) {
                    String gtidSet = rs.getString(5);
                    offsetContext.setCompletedGtidSet(gtidSet);
                    LOGGER.info("\t using binlog '{}' at position '{}' and gtid '{}'", new Object[]{binlogFilename, binlogPosition, gtidSet});
                }
            } else if (!snapshotterService.getSnapshotter().shouldStream()) {
                LOGGER.warn("Failed retrieving binlog position, continuing as streaming CDC wasn't requested");
            } else {
                throw new DebeziumException("Cannot read the binlog filename and position via '" + showMasterStmt + "'. Make sure your server is correctly configured");
            }
        });
    }

    protected MySqlOffsetContext copyOffset(RelationalSnapshotChangeEventSource.RelationalSnapshotContext<MySqlPartition, MySqlOffsetContext> snapshotContext) {
        return new MySqlOffsetContext.Loader(this.connectorConfig).load(((MySqlOffsetContext)snapshotContext.offset).getOffset());
    }
}

