/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.antlr.listener;

import io.debezium.antlr.AntlrDdlParser;
import io.debezium.connector.oracle.antlr.OracleDmlParser;
import io.debezium.connector.oracle.antlr.listener.BaseDmlParserListener;
import io.debezium.connector.oracle.antlr.listener.ParserUtils;
import io.debezium.connector.oracle.logminer.valueholder.LogMinerColumnValue;
import io.debezium.connector.oracle.logminer.valueholder.LogMinerColumnValueWrapper;
import io.debezium.connector.oracle.logminer.valueholder.LogMinerDmlEntryImpl;
import io.debezium.data.Envelope;
import io.debezium.ddl.parser.oracle.generated.PlSqlParser;
import io.debezium.relational.Column;
import io.debezium.text.ParsingException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;

public class InsertParserListener
extends BaseDmlParserListener<Integer> {
    InsertParserListener(String catalogName, String schemaName, OracleDmlParser parser) {
        super(catalogName, schemaName, parser);
    }

    @Override
    protected Integer getKey(Column column, int index) {
        return index;
    }

    public void enterInsert_statement(PlSqlParser.Insert_statementContext ctx) {
        this.init(ctx.single_table_insert().insert_into_clause().general_table_ref().dml_table_expression_clause());
        this.oldColumnValues.clear();
        super.enterInsert_statement(ctx);
    }

    public void enterValues_clause(PlSqlParser.Values_clauseContext ctx) {
        if (this.table == null) {
            throw new ParsingException(null, "Trying to parse a statement for a table which does not exist. Statement: " + AntlrDdlParser.getText((ParserRuleContext)ctx));
        }
        List values = ctx.expressions().expression();
        for (int i = 0; i < values.size(); ++i) {
            PlSqlParser.ExpressionContext value = (PlSqlParser.ExpressionContext)values.get(i);
            LogMinerColumnValueWrapper columnObject = (LogMinerColumnValueWrapper)this.newColumnValues.get(i);
            String columnName = columnObject.getColumnValue().getColumnName();
            Column column = this.table.columnWithName(columnName);
            String valueText = value.logical_expression().getText();
            valueText = ParserUtils.removeApostrophes(valueText);
            Object valueObject = ParserUtils.convertValueToSchemaType(column, valueText, this.converter);
            columnObject.getColumnValue().setColumnData(valueObject);
        }
        super.enterValues_clause(ctx);
    }

    public void exitSingle_table_insert(PlSqlParser.Single_table_insertContext ctx) {
        List<LogMinerColumnValue> actualNewValues = this.newColumnValues.values().stream().map(LogMinerColumnValueWrapper::getColumnValue).collect(Collectors.toList());
        LogMinerDmlEntryImpl newRecord = new LogMinerDmlEntryImpl(Envelope.Operation.CREATE, actualNewValues, Collections.emptyList());
        this.parser.setDmlEntry(newRecord);
        super.exitSingle_table_insert(ctx);
    }
}

