/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.xstream;

import io.debezium.config.EnumeratedValue;

public enum OracleVersion implements EnumeratedValue
{
    V11("11"),
    V12Plus("12+");

    private final String version;

    private OracleVersion(String version) {
        this.version = version;
    }

    public String getValue() {
        return this.version;
    }

    public int getPosVersion() {
        switch (this.version) {
            case "11": {
                return 1;
            }
            case "12+": {
                return 2;
            }
        }
        return 2;
    }

    public static OracleVersion parse(String value) {
        if (value == null) {
            return null;
        }
        value = value.trim();
        for (OracleVersion option : OracleVersion.values()) {
            if (!option.getValue().equalsIgnoreCase(value)) continue;
            return option;
        }
        return null;
    }

    public static OracleVersion parse(String value, String defaultValue) {
        OracleVersion option = OracleVersion.parse(value);
        if (option == null && defaultValue != null) {
            option = OracleVersion.parse(defaultValue);
        }
        return option;
    }
}

