/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.AbstractSourceInfo;
import io.debezium.connector.AbstractSourceInfoStructMaker;
import io.debezium.connector.oracle.CommitScn;
import io.debezium.connector.oracle.SourceInfo;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;

public class OracleSourceInfoStructMaker
extends AbstractSourceInfoStructMaker<SourceInfo> {
    private final Schema schema;

    public OracleSourceInfoStructMaker(String connector, String version, CommonConnectorConfig connectorConfig) {
        super(connector, version, connectorConfig);
        SchemaBuilder schemaBuilder = this.commonSchemaBuilder().name("io.debezium.connector.oracle.Source").field("schema", Schema.STRING_SCHEMA).field("table", Schema.STRING_SCHEMA).field("txId", Schema.OPTIONAL_STRING_SCHEMA).field("scn", Schema.OPTIONAL_STRING_SCHEMA).field("commit_scn", Schema.OPTIONAL_STRING_SCHEMA).field("lcr_position", Schema.OPTIONAL_STRING_SCHEMA);
        this.schema = CommitScn.schemaBuilder(schemaBuilder).build();
    }

    public Schema schema() {
        return this.schema;
    }

    public Struct struct(SourceInfo sourceInfo) {
        CommitScn commitScn;
        String eventScn = sourceInfo.getEventScn() == null ? null : sourceInfo.getEventScn().toString();
        Struct ret = super.commonStruct((AbstractSourceInfo)sourceInfo).put("schema", (Object)sourceInfo.tableSchema()).put("table", (Object)sourceInfo.table()).put("txId", (Object)sourceInfo.getTransactionId()).put("scn", (Object)eventScn);
        if (sourceInfo.getLcrPosition() != null) {
            ret.put("lcr_position", (Object)sourceInfo.getLcrPosition());
        }
        if ((commitScn = sourceInfo.getCommitScn()) != null) {
            commitScn.store(sourceInfo, ret);
        }
        return ret;
    }
}

