/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer;

import io.debezium.DebeziumException;
import io.debezium.connector.oracle.BaseChangeRecordEmitter;
import io.debezium.connector.oracle.logminer.events.EventType;
import io.debezium.data.Envelope;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Partition;
import io.debezium.relational.Table;
import io.debezium.util.Clock;

public class LogMinerChangeRecordEmitter
extends BaseChangeRecordEmitter<Object> {
    private final Envelope.Operation operation;
    private final Object[] oldValues;
    private final Object[] newValues;

    public LogMinerChangeRecordEmitter(Partition partition, OffsetContext offset, Envelope.Operation operation, Object[] oldValues, Object[] newValues, Table table, Clock clock) {
        super(partition, offset, table, clock);
        this.oldValues = oldValues;
        this.newValues = newValues;
        this.operation = operation;
    }

    public LogMinerChangeRecordEmitter(Partition partition, OffsetContext offset, EventType eventType, Object[] oldValues, Object[] newValues, Table table, Clock clock) {
        this(partition, offset, LogMinerChangeRecordEmitter.getOperation(eventType), oldValues, newValues, table, clock);
    }

    private static Envelope.Operation getOperation(EventType eventType) {
        switch (eventType) {
            case INSERT: {
                return Envelope.Operation.CREATE;
            }
            case UPDATE: 
            case SELECT_LOB_LOCATOR: {
                return Envelope.Operation.UPDATE;
            }
            case DELETE: {
                return Envelope.Operation.DELETE;
            }
        }
        throw new DebeziumException("Unsupported operation type: " + (Object)((Object)eventType));
    }

    public Envelope.Operation getOperation() {
        return this.operation;
    }

    protected Object[] getOldColumnValues() {
        return this.oldValues;
    }

    protected Object[] getNewColumnValues() {
        return this.newValues;
    }
}

