/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer.processor.infinispan;

import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleDatabaseSchema;
import io.debezium.connector.oracle.OracleOffsetContext;
import io.debezium.connector.oracle.OraclePartition;
import io.debezium.connector.oracle.OracleStreamingChangeEventSourceMetrics;
import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.logminer.LogMinerQueryBuilder;
import io.debezium.connector.oracle.logminer.events.LogMinerEvent;
import io.debezium.connector.oracle.logminer.events.LogMinerEventRow;
import io.debezium.connector.oracle.logminer.processor.AbstractLogMinerEventProcessor;
import io.debezium.connector.oracle.logminer.processor.infinispan.CacheProvider;
import io.debezium.connector.oracle.logminer.processor.infinispan.InfinispanTransaction;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Partition;
import io.debezium.relational.TableId;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.time.Duration;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractInfinispanLogMinerEventProcessor
extends AbstractLogMinerEventProcessor<InfinispanTransaction>
implements CacheProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractInfinispanLogMinerEventProcessor.class);
    private final OracleConnection jdbcConnection;
    private final OracleStreamingChangeEventSourceMetrics metrics;
    private final OraclePartition partition;
    private final OracleOffsetContext offsetContext;
    private final EventDispatcher<OraclePartition, TableId> dispatcher;

    public AbstractInfinispanLogMinerEventProcessor(ChangeEventSource.ChangeEventSourceContext context, OracleConnectorConfig connectorConfig, OracleConnection jdbcConnection, EventDispatcher<OraclePartition, TableId> dispatcher, OraclePartition partition, OracleOffsetContext offsetContext, OracleDatabaseSchema schema, OracleStreamingChangeEventSourceMetrics metrics) {
        super(context, connectorConfig, schema, partition, offsetContext, dispatcher, metrics);
        this.jdbcConnection = jdbcConnection;
        this.metrics = metrics;
        this.partition = partition;
        this.offsetContext = offsetContext;
        this.dispatcher = dispatcher;
    }

    @Override
    public void displayCacheStatistics() {
        LOGGER.info("Overall Cache Statistics:");
        LOGGER.info("\tTransactions        : {}", (Object)this.getTransactionCache().size());
        LOGGER.info("\tRecent Transactions : {}", (Object)this.getProcessedTransactionsCache().size());
        LOGGER.info("\tSchema Changes      : {}", (Object)this.getSchemaChangesCache().size());
        LOGGER.info("\tEvents              : {}", (Object)this.getEventCache().size());
        if (!this.getEventCache().isEmpty()) {
            for (String eventKey : this.getEventCache().keySet()) {
                LOGGER.debug("\t\tFound Key: {}", (Object)eventKey);
            }
        }
    }

    @Override
    protected boolean isRecentlyProcessed(String transactionId) {
        return this.getProcessedTransactionsCache().containsKey((Object)transactionId);
    }

    @Override
    protected InfinispanTransaction createTransaction(LogMinerEventRow row) {
        return new InfinispanTransaction(row.getTransactionId(), row.getScn(), row.getChangeTime(), row.getUserName());
    }

    @Override
    protected void removeEventWithRowId(LogMinerEventRow row) {
        List<String> eventKeys = this.getTransactionKeysWithPrefix(row.getTransactionId() + "-");
        if (eventKeys.isEmpty() && this.isTransactionIdWithNoSequence(row.getTransactionId())) {
            String transactionPrefix = this.getTransactionIdPrefix(row.getTransactionId());
            LOGGER.debug("Undo change refers to a transaction that has no explicit sequence, '{}'", (Object)row.getTransactionId());
            LOGGER.debug("Checking all transactions with prefix '{}'", (Object)transactionPrefix);
            eventKeys = this.getTransactionKeysWithPrefix(transactionPrefix);
            if (!eventKeys.isEmpty()) {
                for (String eventKey : eventKeys) {
                    LogMinerEvent event = (LogMinerEvent)this.getEventCache().get((Object)eventKey);
                    if (event == null || !event.getRowId().equals(row.getRowId())) continue;
                    LOGGER.debug("Undo change '{}' applied to transaction '{}'", (Object)row, (Object)eventKey);
                    this.getEventCache().remove((Object)eventKey);
                    return;
                }
                LOGGER.warn("Cannot undo change '{}' since event with row-id {} was not found.", (Object)row, (Object)row.getRowId());
            } else {
                LOGGER.warn("Cannot undo change '{}' since transaction was not found.", (Object)row);
            }
        } else {
            for (String eventKey : eventKeys) {
                LogMinerEvent event = (LogMinerEvent)this.getEventCache().get((Object)eventKey);
                if (event == null || !event.getRowId().equals(row.getRowId())) continue;
                LOGGER.trace("Undo applied for event {}.", (Object)event);
                this.getEventCache().remove((Object)eventKey);
                return;
            }
            LOGGER.warn("Cannot undo change '{}' since event with row-id {} was not found.", (Object)row, (Object)row.getRowId());
        }
    }

    private List<String> getTransactionKeysWithPrefix(String prefix) {
        return this.getEventCache().keySet().stream().filter(k -> k.startsWith(prefix)).collect(Collectors.toList());
    }

    @Override
    protected void processRow(OraclePartition partition, LogMinerEventRow row) throws SQLException, InterruptedException {
        String transactionId = row.getTransactionId();
        if (this.isRecentlyProcessed(transactionId)) {
            LOGGER.trace("Transaction {} has been seen by connector, skipped.", (Object)transactionId);
            return;
        }
        super.processRow(partition, row);
    }

    @Override
    public void abandonTransactions(Duration retention) throws InterruptedException {
    }

    @Override
    protected boolean hasSchemaChangeBeenSeen(LogMinerEventRow row) {
        return this.getSchemaChangesCache().containsKey((Object)row.getScn().toString());
    }

    @Override
    protected InfinispanTransaction getAndRemoveTransactionFromCache(String transactionId) {
        InfinispanTransaction transaction = (InfinispanTransaction)this.getTransactionCache().get((Object)transactionId);
        if (transaction != null) {
            this.getTransactionCache().remove((Object)transactionId);
        }
        return transaction;
    }

    @Override
    protected void removeTransactionAndEventsFromCache(InfinispanTransaction transaction) {
        this.removeEventsWithTransaction(transaction);
        this.getTransactionCache().remove((Object)transaction.getTransactionId());
    }

    @Override
    protected Iterator<LogMinerEvent> getTransactionEventIterator(final InfinispanTransaction transaction) {
        return new Iterator<LogMinerEvent>(){
            private final int count;
            private LogMinerEvent nextEvent;
            private int index;
            {
                this.count = transaction.getNumberOfEvents();
                this.index = 0;
            }

            @Override
            public boolean hasNext() {
                while (this.index < this.count) {
                    this.nextEvent = (LogMinerEvent)AbstractInfinispanLogMinerEventProcessor.this.getEventCache().get((Object)transaction.getEventId(this.index));
                    if (this.nextEvent != null) break;
                    LOGGER.trace("Event {} must have been undone, skipped.", (Object)this.index);
                    ++this.index;
                }
                return this.index < this.count;
            }

            @Override
            public LogMinerEvent next() {
                ++this.index;
                return this.nextEvent;
            }
        };
    }

    @Override
    protected void finalizeTransactionCommit(String transactionId, Scn commitScn) {
        this.getProcessedTransactionsCache().put((Object)transactionId, (Object)commitScn.toString());
    }

    @Override
    protected void finalizeTransactionRollback(String transactionId, Scn rollbackScn) {
        InfinispanTransaction transaction = (InfinispanTransaction)this.getTransactionCache().get((Object)transactionId);
        if (transaction != null) {
            this.removeEventsWithTransaction(transaction);
            this.getTransactionCache().remove((Object)transactionId);
        }
        this.getProcessedTransactionsCache().put((Object)transactionId, (Object)rollbackScn.toString());
    }

    @Override
    protected void handleSchemaChange(LogMinerEventRow row) throws InterruptedException {
        super.handleSchemaChange(row);
        if (row.getTableName() != null) {
            this.getSchemaChangesCache().put((Object)row.getScn().toString(), (Object)row.getTableId().identifier());
        }
    }

    @Override
    protected void addToTransaction(String transactionId, LogMinerEventRow row, Supplier<LogMinerEvent> eventSupplier) {
        if (!this.isRecentlyProcessed(transactionId)) {
            InfinispanTransaction transaction = (InfinispanTransaction)this.getTransactionCache().get((Object)transactionId);
            if (transaction == null) {
                LOGGER.trace("Transaction {} is not in cache, creating.", (Object)transactionId);
                transaction = this.createTransaction(row);
            }
            String eventKey = transaction.getEventId(transaction.getNextEventId());
            if (!this.getEventCache().containsKey((Object)eventKey)) {
                LOGGER.trace("Transaction {}, adding event reference at key {}", (Object)transactionId, (Object)eventKey);
                this.getEventCache().put((Object)eventKey, (Object)eventSupplier.get());
                this.metrics.calculateLagMetrics(row.getChangeTime());
            }
            this.getTransactionCache().put((Object)transactionId, (Object)transaction);
            this.metrics.setActiveTransactions(this.getTransactionCache().size());
        } else {
            LOGGER.warn("Event for transaction {} skipped as transaction has been processed.", (Object)transactionId);
        }
    }

    @Override
    protected int getTransactionEventCount(InfinispanTransaction transaction) {
        return (int)this.getEventCache().keySet().parallelStream().filter(k -> k.startsWith(transaction.getTransactionId() + "-")).count();
    }

    @Override
    protected PreparedStatement createQueryStatement() throws SQLException {
        String query = LogMinerQueryBuilder.build(this.getConfig(), this.getSchema());
        return this.jdbcConnection.connection().prepareStatement(query, 1003, 1007, 1);
    }

    @Override
    protected Scn calculateNewStartScn(Scn endScn, Scn maxCommittedScn) throws InterruptedException {
        Scn minCacheScn = this.getTransactionCacheMinimumScn();
        if (!minCacheScn.isNull()) {
            this.getProcessedTransactionsCache().entrySet().removeIf(entry -> Scn.valueOf((String)entry.getValue()).compareTo(minCacheScn) < 0);
            this.getSchemaChangesCache().entrySet().removeIf(entry -> Scn.valueOf((String)entry.getKey()).compareTo(minCacheScn) < 0);
        } else {
            this.getProcessedTransactionsCache().clear();
            this.getSchemaChangesCache().clear();
        }
        if (this.getConfig().isLobEnabled()) {
            if (this.getTransactionCache().isEmpty() && !maxCommittedScn.isNull()) {
                this.offsetContext.setScn(maxCommittedScn);
                this.dispatcher.dispatchHeartbeatEvent((Partition)this.partition, (OffsetContext)this.offsetContext);
            } else if (!minCacheScn.isNull()) {
                this.offsetContext.setScn(minCacheScn.subtract(Scn.valueOf(1)));
                this.dispatcher.dispatchHeartbeatEvent((Partition)this.partition, (OffsetContext)this.offsetContext);
            }
            return this.offsetContext.getScn();
        }
        if (!this.getLastProcessedScn().isNull() && this.getLastProcessedScn().compareTo(endScn) < 0) {
            endScn = this.getLastProcessedScn();
        }
        this.offsetContext.setScn(endScn);
        this.metrics.setOldestScn(endScn);
        this.metrics.setOffsetScn(endScn);
        this.dispatcher.dispatchHeartbeatEvent((Partition)this.partition, (OffsetContext)this.offsetContext);
        return endScn;
    }

    private void removeEventsWithTransaction(InfinispanTransaction transaction) {
        for (int i = 0; i < transaction.getNumberOfEvents(); ++i) {
            this.getEventCache().remove((Object)transaction.getEventId(i));
        }
    }
}

