/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.rest;

import io.debezium.config.Configuration;
import io.debezium.connector.oracle.Module;
import io.debezium.connector.oracle.OracleConnector;
import io.debezium.rest.ConnectionValidationResource;
import io.debezium.rest.FilterValidationResource;
import io.debezium.rest.MetricsResource;
import io.debezium.rest.SchemaResource;
import io.debezium.rest.model.DataCollection;
import io.debezium.rest.model.MetricsDescriptor;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.management.MalformedObjectNameException;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.kafka.connect.health.ConnectClusterState;

@Path(value="/debezium/oracle")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class DebeziumOracleConnectorResource
implements SchemaResource,
ConnectionValidationResource<OracleConnector>,
FilterValidationResource<OracleConnector>,
MetricsResource {
    public static final String BASE_PATH = "/debezium/oracle";
    public static final String VERSION_ENDPOINT = "/version";
    private final ConnectClusterState connectClusterState;

    public DebeziumOracleConnectorResource(ConnectClusterState connectClusterState) {
        this.connectClusterState = connectClusterState;
    }

    public String getSchemaFilePath() {
        return "/META-INF/resources/oracle.json";
    }

    public OracleConnector getConnector() {
        return new OracleConnector();
    }

    public MetricsDescriptor getMetrics(String connectorName) throws MalformedObjectNameException {
        Map connectorConfig = this.connectClusterState.connectorConfig(connectorName);
        return this.queryMetrics(connectorConfig, connectorName, Module.contextName().toLowerCase(), "streaming");
    }

    @GET
    @Path(value="/version")
    public String getConnectorVersion() {
        return Module.version();
    }

    public List<DataCollection> getMatchingCollections(Configuration configuration) {
        return this.getConnector().getMatchingCollections(configuration).stream().map(tableId -> new DataCollection(tableId.schema(), tableId.table())).collect(Collectors.toList());
    }
}

