/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import java.math.BigInteger;
import java.util.Objects;

public class Scn
implements Comparable<Scn> {
    public static final Scn MAX = new Scn(BigInteger.valueOf(-2L));
    public static final Scn NULL = new Scn(null);
    public static final Scn ONE = new Scn(BigInteger.valueOf(1L));
    private final BigInteger scn;

    public Scn(BigInteger scn) {
        this.scn = scn;
    }

    public boolean isNull() {
        return this.scn == null;
    }

    public static Scn valueOf(int value) {
        return new Scn(BigInteger.valueOf(value));
    }

    public static Scn valueOf(long value) {
        return new Scn(BigInteger.valueOf(value));
    }

    public static Scn valueOf(String value) {
        return new Scn(new BigInteger(value));
    }

    public long longValue() {
        return this.isNull() ? 0L : this.scn.longValue();
    }

    public BigInteger asBigInteger() {
        return this.scn;
    }

    public Scn add(Scn value) {
        if (this.isNull() && value.isNull()) {
            return NULL;
        }
        if (value.isNull()) {
            return new Scn(this.scn);
        }
        if (this.isNull()) {
            return new Scn(value.scn);
        }
        return new Scn(this.scn.add(value.scn));
    }

    public Scn subtract(Scn value) {
        if (this.isNull() && value.isNull()) {
            return NULL;
        }
        if (value.isNull()) {
            return new Scn(this.scn);
        }
        if (this.isNull()) {
            return new Scn(value.scn.negate());
        }
        return new Scn(this.scn.subtract(value.scn));
    }

    @Override
    public int compareTo(Scn o) {
        if (this.isNull() && o.isNull()) {
            return 0;
        }
        if (this.isNull() && !o.isNull()) {
            return -1;
        }
        if (!this.isNull() && o.isNull()) {
            return 1;
        }
        return this.scn.compareTo(o.scn);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Scn scn1 = (Scn)o;
        return Objects.equals(this.scn, scn1.scn);
    }

    public int hashCode() {
        return Objects.hash(this.scn);
    }

    public String toString() {
        return this.isNull() ? "null" : this.scn.toString();
    }
}

