/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.annotation.Immutable;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.connector.oracle.OracleConnector;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.util.Collect;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.util.Iterator;
import java.util.Set;

public class OracleErrorHandler
extends ErrorHandler {
    @Immutable
    private static final Set<String> RETRIABLE_ERROR_CODES = Collect.unmodifiableSet((Object[])new String[]{"ORA-03135", "ORA-12543", "ORA-00604", "ORA-01089", "ORA-01333", "ORA-01284", "ORA-26653", "ORA-01291", "ORA-01327", "ORA-04030", "ORA-00310", "ORA-01343", "ORA-01371"});
    @Immutable
    private static final Set<String> RETRIABLE_ERROR_MESSAGES = Collect.unmodifiableSet((Object[])new String[]{"No more data to read from socket", "immediate shutdown or close in progress", "failed to exclusively lock system dictionary"});
    @Immutable
    private static final Set<String> RETRIABLE_ORA600_ERROR_MESSAGES = Collect.unmodifiableSet((Object[])new String[]{"krvrdGetUID"});

    public OracleErrorHandler(OracleConnectorConfig connectorConfig, ChangeEventQueue<?> queue, ErrorHandler replacedErrorHandler) {
        super(OracleConnector.class, (CommonConnectorConfig)connectorConfig, queue, replacedErrorHandler);
    }

    protected boolean isRetriable(Throwable throwable) {
        while (throwable != null) {
            Throwable cause;
            String message;
            if (throwable instanceof SQLRecoverableException) {
                return true;
            }
            if (throwable instanceof SQLException) {
                SQLException sqlException = (SQLException)throwable;
                Iterator<String> message2 = sqlException.getMessage();
                if (sqlException.getErrorCode() == 600 || message2 != null && ((String)((Object)message2)).startsWith("ORA-00600")) {
                    for (String match : RETRIABLE_ORA600_ERROR_MESSAGES) {
                        if (!((String)((Object)message2)).contains(match)) continue;
                        return true;
                    }
                }
            }
            if ((message = throwable.getMessage()) != null && message.length() > 0) {
                for (String errorCode : RETRIABLE_ERROR_CODES) {
                    if (!message.startsWith(errorCode)) continue;
                    return true;
                }
                for (String messageText : RETRIABLE_ERROR_MESSAGES) {
                    if (!message.toUpperCase().contains(messageText.toUpperCase())) continue;
                    return true;
                }
            }
            if (throwable.getCause() != null && (cause = throwable.getCause()) instanceof IOException) {
                return true;
            }
            throwable = throwable.getCause();
        }
        return false;
    }
}

