/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.DebeziumException;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleDatabaseSchema;
import io.debezium.data.Envelope;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.pipeline.spi.ChangeRecordEmitter;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Partition;
import io.debezium.relational.Column;
import io.debezium.relational.RelationalChangeRecordEmitter;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.TableSchema;
import io.debezium.schema.DataCollectionSchema;
import io.debezium.util.Clock;
import io.debezium.util.Strings;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.kafka.connect.data.Struct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseChangeRecordEmitter<T>
extends RelationalChangeRecordEmitter {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseChangeRecordEmitter.class);
    private final OracleConnectorConfig connectorConfig;
    private final Object[] oldColumnValues;
    private final Object[] newColumnValues;
    private final OracleDatabaseSchema schema;
    protected final Table table;

    protected BaseChangeRecordEmitter(OracleConnectorConfig connectorConfig, Partition partition, OffsetContext offset, OracleDatabaseSchema schema, Table table, Clock clock, Object[] oldColumnValues, Object[] newColumnValues) {
        super(partition, offset, clock, (RelationalDatabaseConnectorConfig)connectorConfig);
        this.connectorConfig = connectorConfig;
        this.schema = schema;
        this.oldColumnValues = oldColumnValues;
        this.newColumnValues = newColumnValues;
        this.table = table;
    }

    protected Object[] getOldColumnValues() {
        return this.oldColumnValues;
    }

    protected Object[] getNewColumnValues() {
        return this.newColumnValues;
    }

    protected void emitTruncateRecord(ChangeRecordEmitter.Receiver receiver, TableSchema tableSchema) throws InterruptedException {
        Struct envelope = tableSchema.getEnvelopeSchema().truncate(this.getOffset().getSourceInfo(), this.getClock().currentTimeAsInstant());
        receiver.changeRecord(this.getPartition(), (DataCollectionSchema)tableSchema, Envelope.Operation.TRUNCATE, null, envelope, this.getOffset(), null);
    }

    protected void emitUpdateAsPrimaryKeyChangeRecord(ChangeRecordEmitter.Receiver receiver, TableSchema tableSchema, Struct oldKey, Struct newKey, Struct oldValue, Struct newValue) throws InterruptedException {
        List<Column> reselectColumns;
        if (this.connectorConfig.isLobEnabled() && !(reselectColumns = this.getReselectColumns(newValue)).isEmpty()) {
            LOGGER.info("Table '{}' primary key changed from '{}' to '{}' via an UPDATE, re-selecting LOB columns {} out of bands.", new Object[]{this.table.id(), oldKey, newKey, reselectColumns.stream().map(Column::name).collect(Collectors.toList())});
            JdbcConfiguration jdbcConfig = this.connectorConfig.getJdbcConfig();
            try (OracleConnection connection = new OracleConnection(jdbcConfig, false);){
                String query = this.getReselectQuery(reselectColumns, this.table, connection);
                if (!Strings.isNullOrBlank((String)this.connectorConfig.getPdbName())) {
                    connection.setSessionToPdb(this.connectorConfig.getPdbName());
                }
                connection.prepareQuery(query, ps -> this.prepareReselectQueryStatement(ps, this.table, this.newColumnValues), rs -> this.updateNewValuesFromReselectQueryResults(rs, reselectColumns));
                newValue = tableSchema.valueFromColumnData(this.newColumnValues);
            }
            catch (SQLException e) {
                throw new DebeziumException("Failed to re-select table with LOB columns due to primary key update", (Throwable)e);
            }
        }
        super.emitUpdateAsPrimaryKeyChangeRecord(receiver, tableSchema, oldKey, newKey, oldValue, newValue);
    }

    private List<Column> getReselectColumns(Struct newValue) {
        List<Column> lobColumns = this.schema.getLobColumnsForTable(this.table.id());
        if (lobColumns.isEmpty()) {
            return Collections.emptyList();
        }
        return lobColumns.stream().filter(column -> newValue.schema().field(column.name()) != null).filter(column -> {
            Object value = newValue.get(column.name());
            return this.schema.isColumnUnavailableValuePlaceholder((Column)column, value);
        }).collect(Collectors.toList());
    }

    private String getReselectQuery(List<Column> reselectColumns, Table table, OracleConnection connection) {
        TableId id = new TableId(null, table.id().schema(), table.id().table());
        StringBuilder query = new StringBuilder("SELECT ").append(reselectColumns.stream().map(c -> connection.quotedColumnIdString(c.name())).collect(Collectors.joining(", "))).append(" FROM ").append(id.toDoubleQuotedString()).append(" WHERE ");
        for (int i = 0; i < table.primaryKeyColumnNames().size(); ++i) {
            if (i > 0) {
                query.append(" AND ");
            }
            query.append(connection.quotedColumnIdString((String)table.primaryKeyColumnNames().get(i))).append("=?");
        }
        return query.toString();
    }

    private void prepareReselectQueryStatement(PreparedStatement ps, Table table, Object[] rawValues) throws SQLException {
        List primaryKeyColumnNames = table.primaryKeyColumnNames();
        for (int i = 0; i < primaryKeyColumnNames.size(); ++i) {
            Column column = table.columnWithName((String)primaryKeyColumnNames.get(i));
            ps.setObject(i + 1, this.convertReselectPrimaryKeyColumn(ps.getConnection(), column, rawValues[column.position() - 1]));
        }
    }

    private void updateNewValuesFromReselectQueryResults(ResultSet rs, List<Column> reselectColumns) throws SQLException {
        if (rs.next()) {
            for (int i = 0; i < reselectColumns.size(); ++i) {
                Column column = reselectColumns.get(i);
                this.newColumnValues[column.position() - 1] = rs.getObject(i + 1);
            }
        }
    }

    protected Object convertReselectPrimaryKeyColumn(Connection connection, Column column, Object value) {
        return value;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected Object convertValueViaQuery(Connection connection, String value) {
        try (Statement statement = connection.createStatement();){
            Object object;
            block15: {
                ResultSet rs = statement.executeQuery(String.format("SELECT %s FROM DUAL", value));
                try {
                    if (!rs.next()) {
                        throw new DebeziumException("Expected query to return a value but did not.");
                    }
                    object = rs.getObject(1);
                    if (rs == null) break block15;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return object;
        }
        catch (SQLException e) {
            throw new DebeziumException(String.format("Failed to execute reselect query for value '%s'.", value), (Throwable)e);
        }
    }
}

