/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer.processor;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

public interface LogMinerCache<K, V> {
    public void entries(Consumer<Stream<Entry<K, V>>> var1);

    default public void keys(Consumer<Stream<K>> keyStreamConsumer) {
        this.entries(entryStream -> keyStreamConsumer.accept(entryStream.map(Entry::getKey)));
    }

    default public void values(Consumer<Stream<V>> valueStreamConsumer) {
        this.entries(entryStream -> valueStreamConsumer.accept(entryStream.map(Entry::getValue)));
    }

    public void clear();

    public V get(K var1);

    public boolean isEmpty();

    public boolean containsKey(K var1);

    public void put(K var1, V var2);

    public V remove(K var1);

    public int size();

    public void forEach(BiConsumer<K, V> var1);

    public void removeIf(Predicate<Entry<K, V>> var1);

    public <T> T streamAndReturn(Function<Stream<Entry<K, V>>, T> var1);

    public static class Entry<K, V> {
        private final K key;
        private final V value;

        public Entry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }
    }
}

