/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer.processor.ehcache;

import io.debezium.DebeziumException;
import io.debezium.config.Configuration;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleDatabaseSchema;
import io.debezium.connector.oracle.OracleOffsetContext;
import io.debezium.connector.oracle.OraclePartition;
import io.debezium.connector.oracle.logminer.LogMinerStreamingChangeEventSourceMetrics;
import io.debezium.connector.oracle.logminer.events.LogMinerEvent;
import io.debezium.connector.oracle.logminer.events.LogMinerEventRow;
import io.debezium.connector.oracle.logminer.processor.AbstractLogMinerEventProcessor;
import io.debezium.connector.oracle.logminer.processor.LogMinerCache;
import io.debezium.connector.oracle.logminer.processor.ehcache.EhcacheLogMinerCache;
import io.debezium.connector.oracle.logminer.processor.ehcache.EhcacheTransaction;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.relational.TableId;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.ehcache.CacheManager;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.xml.XmlConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class EhcacheLogMinerEventProcessor
extends AbstractLogMinerEventProcessor<EhcacheTransaction> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EhcacheLogMinerEventProcessor.class);
    private final CacheManager cacheManager;
    private final LogMinerCache<String, EhcacheTransaction> transactionsCache;
    private final LogMinerCache<String, LogMinerEvent> eventCache;
    private final LogMinerCache<String, String> processedTransactionsCache;
    private final LogMinerCache<String, String> schemaChangesCache;

    public EhcacheLogMinerEventProcessor(ChangeEventSource.ChangeEventSourceContext context, OracleConnectorConfig connectorConfig, OracleConnection jdbcConnection, EventDispatcher<OraclePartition, TableId> dispatcher, OraclePartition partition, OracleOffsetContext offsetContext, OracleDatabaseSchema schema, LogMinerStreamingChangeEventSourceMetrics metrics) {
        super(context, connectorConfig, schema, partition, offsetContext, dispatcher, metrics, jdbcConnection);
        LOGGER.info("Using Ehcache buffer");
        this.cacheManager = this.createCacheManager(connectorConfig);
        this.transactionsCache = new EhcacheLogMinerCache<String, EhcacheTransaction>(this.cacheManager.getCache("transactions", String.class, EhcacheTransaction.class));
        this.processedTransactionsCache = new EhcacheLogMinerCache<String, String>(this.cacheManager.getCache("processed-transactions", String.class, String.class));
        this.schemaChangesCache = new EhcacheLogMinerCache<String, String>(this.cacheManager.getCache("schema-changes", String.class, String.class));
        this.eventCache = new EhcacheLogMinerCache<String, LogMinerEvent>(this.cacheManager.getCache("events", String.class, LogMinerEvent.class));
    }

    @Override
    protected EhcacheTransaction createTransaction(LogMinerEventRow row) {
        return new EhcacheTransaction(row.getTransactionId(), row.getScn(), row.getChangeTime(), row.getUserName(), row.getThread());
    }

    @Override
    public LogMinerCache<String, EhcacheTransaction> getTransactionCache() {
        return this.transactionsCache;
    }

    @Override
    public LogMinerCache<String, LogMinerEvent> getEventCache() {
        return this.eventCache;
    }

    @Override
    public LogMinerCache<String, String> getSchemaChangesCache() {
        return this.schemaChangesCache;
    }

    @Override
    public LogMinerCache<String, String> getProcessedTransactionsCache() {
        return this.processedTransactionsCache;
    }

    @Override
    public void close() throws Exception {
        if (this.cacheManager != null) {
            this.cacheManager.close();
        }
    }

    private CacheManager createCacheManager(OracleConnectorConfig connectorConfig) {
        try {
            Configuration ehcacheConfig = connectorConfig.getLogMiningEhcacheConfiguration();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            String xmlData = this.getConfigurationWithSubstitutions(ehcacheConfig);
            LOGGER.debug("Using Ehcache XML configuration:\n{}", (Object)xmlData);
            Document xmlDocument = builder.parse(new InputSource(new StringReader(xmlData)));
            CacheManager cacheManager = CacheManagerBuilder.newCacheManager((org.ehcache.config.Configuration)new XmlConfiguration(xmlDocument));
            cacheManager.init();
            return cacheManager;
        }
        catch (Exception e) {
            throw new DebeziumException("Failed to create Ehcache cache manager", (Throwable)e);
        }
    }

    private String getConfigurationWithSubstitutions(Configuration configuration) {
        return this.readConfigurationTemplate().replace("${log.mining.buffer.ehcache.global.config}", configuration.getString(OracleConnectorConfig.LOG_MINING_BUFFER_EHCACHE_GLOBAL_CONFIG, "")).replace("${log.mining.buffer.ehcache.transactions.config}", configuration.getString(OracleConnectorConfig.LOG_MINING_BUFFER_EHCACHE_TRANSACTIONS_CONFIG, "")).replace("${log.mining.buffer.ehcache.processedtransactions.config}", configuration.getString(OracleConnectorConfig.LOG_MINING_BUFFER_EHCACHE_PROCESSED_TRANSACTIONS_CONFIG, "")).replace("${log.mining.buffer.ehcache.schemachanges.config}", configuration.getString(OracleConnectorConfig.LOG_MINING_BUFFER_EHCACHE_SCHEMA_CHANGES_CONFIG, "")).replace("${log.mining.buffer.ehcache.events.config}", configuration.getString(OracleConnectorConfig.LOG_MINING_BUFFER_EHCACHE_EVENTS_CONFIG, ""));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private String readConfigurationTemplate() {
        try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("ehcache/configuration-template.xml");){
            String string;
            block12: {
                BufferedReader reader = null;
                try {
                    reader = new BufferedReader(new InputStreamReader(inputStream));
                    string = reader.lines().collect(Collectors.joining(System.lineSeparator()));
                    if (reader == null) break block12;
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        reader.close();
                    }
                    throw throwable;
                }
                reader.close();
            }
            return string;
        }
        catch (Exception e) {
            throw new DebeziumException("Failed to read Ehcache configuration template", (Throwable)e);
        }
    }
}

