/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer.processor.memory;

import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleDatabaseSchema;
import io.debezium.connector.oracle.OracleOffsetContext;
import io.debezium.connector.oracle.OraclePartition;
import io.debezium.connector.oracle.logminer.LogMinerStreamingChangeEventSourceMetrics;
import io.debezium.connector.oracle.logminer.events.LogMinerEvent;
import io.debezium.connector.oracle.logminer.events.LogMinerEventRow;
import io.debezium.connector.oracle.logminer.processor.AbstractLogMinerEventProcessor;
import io.debezium.connector.oracle.logminer.processor.LogMinerCache;
import io.debezium.connector.oracle.logminer.processor.memory.MemoryBasedLogMinerCache;
import io.debezium.connector.oracle.logminer.processor.memory.MemoryTransaction;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.relational.TableId;

public class MemoryLogMinerEventProcessor
extends AbstractLogMinerEventProcessor<MemoryTransaction> {
    private final LogMinerCache<String, MemoryTransaction> transactionCache = new MemoryBasedLogMinerCache<String, MemoryTransaction>();
    private final LogMinerCache<String, LogMinerEvent> eventCache = new MemoryBasedLogMinerCache<String, LogMinerEvent>();
    private final LogMinerCache<String, String> schemaCache = new MemoryBasedLogMinerCache<String, String>();
    private final LogMinerCache<String, String> processedTransactionsCache = new MemoryBasedLogMinerCache<String, String>();

    public MemoryLogMinerEventProcessor(ChangeEventSource.ChangeEventSourceContext context, OracleConnectorConfig connectorConfig, OracleConnection jdbcConnection, EventDispatcher<OraclePartition, TableId> dispatcher, OraclePartition partition, OracleOffsetContext offsetContext, OracleDatabaseSchema schema, LogMinerStreamingChangeEventSourceMetrics metrics) {
        super(context, connectorConfig, schema, partition, offsetContext, dispatcher, metrics, jdbcConnection);
    }

    @Override
    protected MemoryTransaction createTransaction(LogMinerEventRow row) {
        return new MemoryTransaction(row.getTransactionId(), row.getScn(), row.getChangeTime(), row.getUserName(), row.getThread());
    }

    @Override
    public LogMinerCache<String, MemoryTransaction> getTransactionCache() {
        return this.transactionCache;
    }

    @Override
    public LogMinerCache<String, LogMinerEvent> getEventCache() {
        return this.eventCache;
    }

    @Override
    public LogMinerCache<String, String> getSchemaChangesCache() {
        return this.schemaCache;
    }

    @Override
    public LogMinerCache<String, String> getProcessedTransactionsCache() {
        return this.processedTransactionsCache;
    }

    @Override
    public void close() throws Exception {
    }
}

