/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer.processor.infinispan.marshalling;

import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.logminer.processor.infinispan.InfinispanTransaction;
import java.time.Instant;
import org.infinispan.protostream.annotations.ProtoAdapter;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;

@ProtoAdapter(value=InfinispanTransaction.class)
public class TransactionAdapter {
    @ProtoFactory
    public InfinispanTransaction factory(String transactionId, String scn, String changeTime, int numberOfEvents, String userName, Integer redoThreadId) {
        return new InfinispanTransaction(transactionId, Scn.valueOf(scn), Instant.parse(changeTime), userName, numberOfEvents, redoThreadId);
    }

    @ProtoField(number=1, required=true)
    public String getTransactionId(InfinispanTransaction transaction) {
        return transaction.getTransactionId();
    }

    @ProtoField(number=2, required=true)
    public String getScn(InfinispanTransaction transaction) {
        return transaction.getStartScn().toString();
    }

    @ProtoField(number=3, required=true)
    public String getChangeTime(InfinispanTransaction transaction) {
        return transaction.getChangeTime().toString();
    }

    @ProtoField(number=4, defaultValue="0")
    public int getNumberOfEvents(InfinispanTransaction transaction) {
        return transaction.getNumberOfEvents();
    }

    @ProtoField(number=5)
    public String getUserName(InfinispanTransaction transaction) {
        return transaction.getUserName();
    }

    @ProtoField(number=6)
    public Integer getRedoThreadId(InfinispanTransaction transaction) {
        return transaction.getRedoThreadId();
    }
}

