/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleValueConverters;
import io.debezium.connector.oracle.StreamingAdapter;
import io.debezium.connector.oracle.antlr.OracleDdlParser;
import io.debezium.relational.Attribute;
import io.debezium.relational.Column;
import io.debezium.relational.DefaultValueConverter;
import io.debezium.relational.HistorizedRelationalDatabaseConnectorConfig;
import io.debezium.relational.HistorizedRelationalDatabaseSchema;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.TableSchemaBuilder;
import io.debezium.relational.Tables;
import io.debezium.relational.ValueConverterProvider;
import io.debezium.schema.SchemaChangeEvent;
import io.debezium.schema.SchemaNameAdjuster;
import io.debezium.spi.topic.TopicNamingStrategy;
import io.debezium.util.LRUCacheMap;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleDatabaseSchema
extends HistorizedRelationalDatabaseSchema {
    private static final Logger LOGGER = LoggerFactory.getLogger(OracleDatabaseSchema.class);
    public static final String ATTRIBUTE_OBJECT_ID = "OBJECT_ID";
    public static final String ATTRIBUTE_DATA_OBJECT_ID = "DATA_OBJECT_ID";
    private static final TableId NO_SUCH_TABLE = new TableId(null, null, "__NULL");
    private final OracleDdlParser ddlParser;
    private final ConcurrentMap<TableId, List<Column>> lobColumnsByTableId = new ConcurrentHashMap<TableId, List<Column>>();
    private final OracleValueConverters valueConverters;
    private final LRUCacheMap<Long, TableId> objectIdToTableId;
    private final boolean extendedStringsSupported;

    public OracleDatabaseSchema(OracleConnectorConfig connectorConfig, OracleValueConverters valueConverters, DefaultValueConverter defaultValueConverter, SchemaNameAdjuster schemaNameAdjuster, TopicNamingStrategy<TableId> topicNamingStrategy, StreamingAdapter.TableNameCaseSensitivity tableNameCaseSensitivity, boolean extendedStringsSupported) {
        super((HistorizedRelationalDatabaseConnectorConfig)connectorConfig, topicNamingStrategy, connectorConfig.getTableFilters().dataCollectionFilter(), connectorConfig.getColumnFilter(), new TableSchemaBuilder((ValueConverterProvider)valueConverters, defaultValueConverter, schemaNameAdjuster, connectorConfig.customConverterRegistry(), connectorConfig.getSourceInfoStructMaker().schema(), connectorConfig.getFieldNamer(), false), StreamingAdapter.TableNameCaseSensitivity.INSENSITIVE.equals((Object)tableNameCaseSensitivity), connectorConfig.getKeyMapper());
        this.valueConverters = valueConverters;
        this.ddlParser = new OracleDdlParser(true, false, connectorConfig.isSchemaCommentsHistoryEnabled(), valueConverters, connectorConfig.getTableFilters().dataCollectionFilter());
        this.objectIdToTableId = new LRUCacheMap(connectorConfig.getObjectIdToTableIdCacheSize());
        this.extendedStringsSupported = extendedStringsSupported;
    }

    public Tables getTables() {
        return this.tables();
    }

    public OracleValueConverters getValueConverters() {
        return this.valueConverters;
    }

    public OracleDdlParser getDdlParser() {
        return this.ddlParser;
    }

    public void applySchemaChange(SchemaChangeEvent schemaChange) {
        block7: {
            block6: {
                LOGGER.debug("Applying schema change event {}", (Object)schemaChange);
                switch (schemaChange.getType()) {
                    case CREATE: 
                    case ALTER: {
                        schemaChange.getTableChanges().forEach(x -> {
                            this.buildAndRegisterSchema(x.getTable());
                            this.tables().overwriteTable(x.getTable());
                        });
                        break;
                    }
                    case DROP: {
                        schemaChange.getTableChanges().forEach(x -> this.removeSchema(x.getId()));
                        break;
                    }
                }
                if (!this.storeOnlyCapturedTables()) break block6;
                if (!schemaChange.getTables().stream().map(Table::id).anyMatch(arg_0 -> ((Tables.TableFilter)this.getTableFilter()).isIncluded(arg_0))) break block7;
            }
            LOGGER.debug("Recorded DDL statements for database '{}': {}", (Object)schemaChange.getDatabase(), (Object)schemaChange.getDdl());
            this.record(schemaChange, schemaChange.getTableChanges());
        }
    }

    protected void removeSchema(TableId id) {
        super.removeSchema(id);
        this.lobColumnsByTableId.remove(id);
    }

    protected void buildAndRegisterSchema(Table table) {
        if (this.getTableFilter().isIncluded(table.id())) {
            super.buildAndRegisterSchema(table);
            this.buildAndRegisterTableLobColumns(table);
            this.buildAndRegisterTableObjectIdReferences(table);
        }
    }

    public TableId getTableIdByObjectId(Long objectId, Long dataObjectId) {
        Objects.requireNonNull(objectId, "The database table object id is null and is not allowed");
        TableId cachedTableId = (TableId)this.objectIdToTableId.get((Object)objectId);
        if (cachedTableId == null) {
            cachedTableId = this.tableObjectIdToTableId(objectId, dataObjectId);
            this.objectIdToTableId.put((Object)objectId, (Object)cachedTableId);
        }
        return cachedTableId == NO_SUCH_TABLE ? null : cachedTableId;
    }

    public List<Column> getLobColumnsForTable(TableId id) {
        return this.lobColumnsByTableId.getOrDefault(id, Collections.emptyList());
    }

    public boolean isColumnUnavailableValuePlaceholder(Column column, Object value) {
        if (OracleDatabaseSchema.isClobColumn(column) || OracleDatabaseSchema.isXmlColumn(column) || OracleDatabaseSchema.isExtendedStringColumn(column)) {
            return this.valueConverters.getUnavailableValuePlaceholderString().equals(value);
        }
        if (OracleDatabaseSchema.isBlobColumn(column)) {
            return ByteBuffer.wrap(this.valueConverters.getUnavailableValuePlaceholderBinary()).equals(value);
        }
        return false;
    }

    public static boolean isNullReplacedByUnavailableValue(Column column) {
        return OracleDatabaseSchema.isLobColumn(column) || OracleDatabaseSchema.isXmlColumn(column) || OracleDatabaseSchema.isExtendedStringColumn(column);
    }

    private static boolean isLobColumn(Column column) {
        return OracleDatabaseSchema.isClobColumn(column) || OracleDatabaseSchema.isBlobColumn(column);
    }

    private static boolean isXmlColumn(Column column) {
        return column.jdbcType() == 2009;
    }

    private static boolean isClobColumn(Column column) {
        return column.jdbcType() == 2005 || column.jdbcType() == 2011;
    }

    private static boolean isBlobColumn(Column column) {
        return column.jdbcType() == 2004;
    }

    private static boolean isExtendedStringColumn(Column column) {
        if (column.jdbcType() == 12 && column.length() > 4000) {
            return true;
        }
        return column.jdbcType() == -9 && column.length() > 2000;
    }

    private void buildAndRegisterTableObjectIdReferences(Table table) {
        Attribute attribute = table.attributeWithName(ATTRIBUTE_OBJECT_ID);
        if (attribute != null) {
            this.objectIdToTableId.put((Object)attribute.asLong(), (Object)table.id());
        }
    }

    private void buildAndRegisterTableLobColumns(Table table) {
        ArrayList<Column> lobColumns = new ArrayList<Column>();
        for (Column column : table.columns()) {
            switch (column.jdbcType()) {
                case 2004: 
                case 2005: 
                case 2009: 
                case 2011: {
                    lobColumns.add(column);
                    break;
                }
                case 12: {
                    if (!this.extendedStringsSupported || column.length() <= 4000) break;
                    lobColumns.add(column);
                    break;
                }
                case -9: {
                    if (!this.extendedStringsSupported || column.length() <= 2000) break;
                    lobColumns.add(column);
                }
            }
        }
        if (!lobColumns.isEmpty()) {
            this.lobColumnsByTableId.put(table.id(), lobColumns);
        } else {
            this.lobColumnsByTableId.remove(table.id());
        }
    }

    private TableId tableObjectIdToTableId(Long tableObjectId, Long dataObjectId) {
        for (TableId tableId : this.tableIds()) {
            Attribute dataAttribute;
            Table table = this.tableFor(tableId);
            Attribute attribute = table.attributeWithName(ATTRIBUTE_OBJECT_ID);
            if (attribute == null || !attribute.asLong().equals(tableObjectId) || dataObjectId != null && ((dataAttribute = table.attributeWithName(ATTRIBUTE_DATA_OBJECT_ID)) == null || !dataAttribute.asLong().equals(dataObjectId))) continue;
            LOGGER.debug("Table lookup for object {} resolved to '{}'", (Object)tableObjectId, (Object)table.id());
            return table.id();
        }
        LOGGER.debug("Table lookup for object id {} did not find a match.", (Object)tableObjectId);
        return NO_SUCH_TABLE;
    }
}

