/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer;

import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.logminer.LogFile;
import io.debezium.connector.oracle.logminer.RetriableLogMinerException;
import java.sql.SQLException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogMinerSessionContext
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogMinerSessionContext.class);
    private final OracleConnection connection;
    private final boolean useContinuousMining;
    private final OracleConnectorConfig.LogMiningStrategy strategy;
    private boolean sessionStarted = false;
    private Duration lastSessionStartTime = Duration.ZERO;

    public LogMinerSessionContext(OracleConnection connection, boolean useContinuousMining, OracleConnectorConfig.LogMiningStrategy strategy) {
        this.connection = connection;
        this.useContinuousMining = useContinuousMining;
        this.strategy = strategy;
    }

    @Override
    public void close() throws Exception {
        this.endMiningSession();
    }

    public Duration getLastSessionStartTime() {
        return this.lastSessionStartTime;
    }

    public boolean isSessionStarted() {
        return this.sessionStarted;
    }

    public void addLogFile(String logFileName) throws SQLException {
        Objects.requireNonNull(logFileName);
        LOGGER.trace("Adding log file '{}' to the mining session.", (Object)logFileName);
        this.connection.executeWithoutCommitting(new String[]{"BEGIN sys.dbms_logmnr.add_logfile(LOGFILENAME => '" + logFileName + "', OPTIONS => DBMS_LOGMNR.ADDFILE); END;"});
    }

    public void addLogFiles(List<LogFile> logFiles) throws SQLException {
        for (LogFile logFile : logFiles) {
            this.addLogFile(logFile.getFileName());
        }
    }

    public void removeAllLogFilesFromSession() throws SQLException {
        this.connection.removeAllLogFilesFromLogMinerSession();
    }

    public void startSession(Scn startScn, Scn endScn, boolean committedDataOnly) throws SQLException {
        Objects.requireNonNull(startScn, "The start SCN must be provided, but can be Scn.NULL");
        Objects.requireNonNull(endScn, "The end SCN must be provided, but can be Scn.NULL");
        try {
            StringBuilder query = new StringBuilder(64);
            query.append("BEGIN sys.dbms_logmnr.start_logmnr(");
            if (!startScn.isNull()) {
                query.append("startScn => '").append(startScn).append("', ");
            }
            if (!endScn.isNull()) {
                query.append("endScn => '").append(endScn).append("', ");
            }
            query.append("options => ").append(String.join((CharSequence)" + ", this.getMiningOptions(committedDataOnly)));
            query.append("); END;");
            Instant startTime = Instant.now();
            this.connection.executeWithoutCommitting(new String[]{query.toString()});
            this.lastSessionStartTime = Duration.between(startTime, Instant.now());
            this.sessionStarted = true;
        }
        catch (SQLException e) {
            if (e.getErrorCode() == 1291 || e.getMessage().startsWith("ORA-01291")) {
                throw new RetriableLogMinerException(e);
            }
            if (e.getErrorCode() == 310 || e.getMessage().startsWith("ORA-00310")) {
                throw new RetriableLogMinerException(e);
            }
            throw e;
        }
    }

    public void endMiningSession() throws SQLException {
        try {
            LOGGER.trace("Ending log mining session");
            this.connection.executeWithoutCommitting(new String[]{"BEGIN SYS.DBMS_LOGMNR.END_LOGMNR(); END;"});
            this.sessionStarted = false;
        }
        catch (SQLException e) {
            if (e.getMessage().toUpperCase().contains("ORA-01307")) {
                LOGGER.info("LogMiner mining session is already closed.");
                return;
            }
            throw e;
        }
    }

    public void writeDataDictionaryToRedoLogs() throws SQLException {
        LOGGER.trace("Building data dictionary");
        this.connection.executeWithoutCommitting(new String[]{"BEGIN DBMS_LOGMNR_D.BUILD (options => DBMS_LOGMNR_D.STORE_IN_REDO_LOGS); END;"});
    }

    private List<String> getMiningOptions(boolean committedDataOnly) {
        ArrayList<String> miningOptions = new ArrayList<String>();
        if (this.strategy.equals((Object)OracleConnectorConfig.LogMiningStrategy.CATALOG_IN_REDO)) {
            miningOptions.add("DBMS_LOGMNR.DICT_FROM_REDO_LOGS");
            miningOptions.add("DBMS_LOGMNR.DDL_DICT_TRACKING");
        } else {
            miningOptions.add("DBMS_LOGMNR.DICT_FROM_ONLINE_CATALOG");
        }
        if (this.useContinuousMining) {
            miningOptions.add("DBMS_LOGMNR.CONTINUOUS_MINE");
        }
        if (committedDataOnly) {
            miningOptions.add("DBMS_LOGMNR.COMMITTED_DATA_ONLY");
        }
        miningOptions.add("DBMS_LOGMNR.NO_ROWID_IN_STMT");
        return miningOptions;
    }
}

