/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer.buffered;

import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.logminer.AbstractLogMinerQueryBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class BufferedLogMinerQueryBuilder
extends AbstractLogMinerQueryBuilder {
    private static final List<Integer> OPERATION_CODES_LOB = Arrays.asList(1, 2, 3, 6, 7, 9, 10, 11, 27, 29, 34, 36, 68, 70, 71, 91, 92, 93, 255);
    private static final List<Integer> OPERATION_CODES_NO_LOB = Arrays.asList(1, 2, 3, 6, 7, 27, 34, 36, 255);
    private static final List<Integer> CTE_OPERATION_CODES_LOB = Arrays.asList(1, 2, 3, 9, 10, 11, 27, 29, 34, 68, 70, 71, 91, 92, 93, 255);
    private static final List<Integer> CTE_OPERATION_CODES_NO_LOB = Arrays.asList(1, 2, 3, 27, 34, 255);

    public BufferedLogMinerQueryBuilder(OracleConnectorConfig connectorConfig) {
        super(connectorConfig);
    }

    @Override
    protected String getPredicates(boolean isCteQuery) {
        String tablesPredicate;
        String schemasPredicate;
        String clientIdPredicate;
        StringBuilder query = new StringBuilder(1024);
        query.append("SCN > ? AND SCN <= ?");
        String multiTenantPredicate = this.getMultiTenantPredicate();
        if (!multiTenantPredicate.isEmpty()) {
            query.append(" AND ").append(multiTenantPredicate);
        }
        query.append(" AND ");
        if (!this.connectorConfig.storeOnlyCapturedTables()) {
            query.append("((");
        }
        query.append(this.getOperationCodePredicate(isCteQuery));
        String userNamePredicate = this.getUserNamePredicate();
        if (!userNamePredicate.isEmpty()) {
            query.append(" AND ").append(userNamePredicate);
        }
        if (!(clientIdPredicate = this.getClientIdPredicate()).isEmpty()) {
            query.append(" AND ").append(clientIdPredicate);
        }
        if (!(schemasPredicate = this.getSchemaNamePredicate()).isEmpty()) {
            query.append(" AND ").append(schemasPredicate);
        }
        if (!(tablesPredicate = this.getTableNamePredicate()).isEmpty()) {
            query.append(" AND ").append(tablesPredicate);
        }
        if (!this.connectorConfig.storeOnlyCapturedTables()) {
            query.append(")").append(BufferedLogMinerQueryBuilder.getDdlPredicate()).append(")");
        }
        return query.toString();
    }

    private String getOperationCodePredicate(boolean isCteQuery) {
        StringBuilder predicate = new StringBuilder();
        AbstractLogMinerQueryBuilder.InClause operationInClause = AbstractLogMinerQueryBuilder.InClause.builder().withField("OPERATION_CODE");
        operationInClause.withValues(this.getOperationCodesList(isCteQuery));
        predicate.append("(").append(operationInClause.build());
        if (this.connectorConfig.storeOnlyCapturedTables()) {
            predicate.append(BufferedLogMinerQueryBuilder.getDdlPredicate());
        }
        return predicate.append(")").toString();
    }

    private static String getDdlPredicate() {
        return " OR (OPERATION_CODE = 5 AND INFO NOT LIKE 'INTERNAL DDL%')";
    }

    private List<Integer> getOperationCodesList(boolean isCteQuery) {
        List<Integer> nonLobOperations;
        if (this.connectorConfig.isLobEnabled()) {
            return isCteQuery ? CTE_OPERATION_CODES_LOB : OPERATION_CODES_LOB;
        }
        List<Integer> list = nonLobOperations = isCteQuery ? CTE_OPERATION_CODES_NO_LOB : OPERATION_CODES_NO_LOB;
        if (this.connectorConfig.isLegacyLogMinerHeapTransactionStartBehaviorEnabled()) {
            ArrayList<Integer> operationCodes = new ArrayList<Integer>(nonLobOperations);
            operationCodes.removeIf(operationCode -> operationCode == 6);
            return operationCodes;
        }
        return nonLobOperations;
    }
}

