/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer.buffered;

import io.debezium.connector.oracle.logminer.buffered.CacheProvider;
import io.debezium.connector.oracle.logminer.buffered.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCacheProvider<T extends Transaction>
implements CacheProvider<T> {
    private final Logger LOGGER = LoggerFactory.getLogger(AbstractCacheProvider.class);

    @Override
    public void displayCacheStatistics() {
        this.LOGGER.info("Overall Cache Statistics:");
        this.LOGGER.info("\tTransactions        : {}", (Object)this.getTransactionCache().getTransactionCount());
        this.LOGGER.info("\tRecent Transactions : {}", (Object)this.getProcessedTransactionsCache().size());
        this.LOGGER.info("\tSchema Changes      : {}", (Object)this.getSchemaChangesCache().size());
        this.LOGGER.info("\tEvents              : {}", (Object)this.getTransactionCache().getTransactionEvents());
        if (!this.getTransactionCache().isEmpty() && this.LOGGER.isDebugEnabled()) {
            this.getTransactionCache().eventKeys(stream -> stream.forEach(eventKey -> this.LOGGER.debug("\t\tFound Key: {}", eventKey)));
        }
    }
}

