/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer.buffered.ehcache;

import io.debezium.connector.oracle.logminer.buffered.LogMinerCache;
import io.debezium.connector.oracle.logminer.buffered.ehcache.CacheCapacityExceededException;
import io.debezium.connector.oracle.logminer.buffered.ehcache.EhcacheEvictionListener;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.ehcache.Cache;

public class EhcacheLogMinerCache<K, V>
implements LogMinerCache<K, V> {
    private final Cache<K, V> cache;
    private final String cacheName;
    private final EhcacheEvictionListener evictionListener;

    public EhcacheLogMinerCache(Cache<K, V> cache, String cacheName, EhcacheEvictionListener evictionListener) {
        this.cache = cache;
        this.cacheName = cacheName;
        this.evictionListener = evictionListener;
    }

    @Override
    public void entries(Consumer<Stream<LogMinerCache.Entry<K, V>>> streamConsumer) {
        streamConsumer.accept(this.getCacheStream().map(e -> new LogMinerCache.Entry<Object, Object>(e.getKey(), e.getValue())));
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public V get(K key) {
        return (V)this.cache.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(K key) {
        return this.cache.containsKey(key);
    }

    @Override
    public void put(K key, V value) {
        this.cache.put(key, value);
        if (this.evictionListener.hasEvictionBeenSeen()) {
            throw new CacheCapacityExceededException(this.cacheName);
        }
    }

    @Override
    public V remove(K key) {
        V value = this.get(key);
        this.cache.remove(key);
        return value;
    }

    @Override
    public int size() {
        int[] count = new int[]{0};
        this.cache.spliterator().forEachRemaining(element -> {
            count[0] = count[0] + 1;
        });
        return count[0];
    }

    @Override
    public void forEach(BiConsumer<K, V> action) {
        this.getCacheStream().forEach((? super T e) -> action.accept(e.getKey(), e.getValue()));
    }

    @Override
    public void removeIf(Predicate<LogMinerCache.Entry<K, V>> predicate) {
        ArrayList keysToRemove = new ArrayList();
        this.forEach((k, v) -> {
            if (predicate.test(new LogMinerCache.Entry<Object, Object>(k, v))) {
                keysToRemove.add(k);
            }
        });
        keysToRemove.forEach(arg_0 -> this.cache.remove(arg_0));
    }

    @Override
    public <T> T streamAndReturn(Function<Stream<LogMinerCache.Entry<K, V>>, T> function) {
        return function.apply(this.getCacheStream().map(e -> new LogMinerCache.Entry<Object, Object>(e.getKey(), e.getValue())));
    }

    private Stream<Cache.Entry<K, V>> getCacheStream() {
        return StreamSupport.stream(this.cache.spliterator(), false);
    }
}

