/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer.logwriter;

import io.debezium.DebeziumException;
import io.debezium.config.Configuration;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.logminer.LogMinerStreamingChangeEventSourceMetrics;
import io.debezium.connector.oracle.logminer.logwriter.CommitLogWriterFlushStrategy;
import io.debezium.connector.oracle.logminer.logwriter.LogWriterFlushStrategy;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.util.Clock;
import io.debezium.util.Metronome;
import io.debezium.util.Strings;
import java.sql.SQLException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RacCommitLogWriterFlushStrategy
implements LogWriterFlushStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(RacCommitLogWriterFlushStrategy.class);
    private final List<RacNode> racNodes = new ArrayList<RacNode>();
    private final LogMinerStreamingChangeEventSourceMetrics streamingMetrics;
    private final JdbcConfiguration jdbcConfiguration;
    private final OracleConnectorConfig connectorConfig;
    private final Set<String> hosts;

    public RacCommitLogWriterFlushStrategy(OracleConnectorConfig connectorConfig, JdbcConfiguration jdbcConfig, LogMinerStreamingChangeEventSourceMetrics streamingMetrics) {
        this.jdbcConfiguration = jdbcConfig;
        this.streamingMetrics = streamingMetrics;
        this.connectorConfig = connectorConfig;
        this.hosts = connectorConfig.getRacNodes().stream().map(String::toUpperCase).collect(Collectors.toSet());
        this.createRacNodesList();
    }

    @Override
    public void close() {
        for (RacNode node : this.racNodes) {
            node.close();
        }
        this.racNodes.clear();
    }

    @Override
    public String getHost() {
        return String.join((CharSequence)", ", this.hosts);
    }

    @Override
    public void flush(Scn currentScn) throws InterruptedException {
        Instant startTime = Instant.now();
        if (this.racNodes.isEmpty()) {
            throw new DebeziumException("No RAC node addresses supplied or currently connected");
        }
        for (RacNode racNode : this.racNodes) {
            if (racNode.isConnected()) continue;
            racNode.reconnect();
        }
        boolean allNodesFlushed = true;
        for (RacNode node : this.racNodes) {
            if (!node.isConnected()) continue;
            LogWriterFlushStrategy strategy = node.getFlushStrategy();
            try {
                strategy.flush(currentScn);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to flush LGWR buffer on RAC node '{}': {}", (Object)node.getHostName(), (Object)e.getMessage());
                node.close();
                allNodesFlushed = false;
            }
        }
        if (!allNodesFlushed) {
            LOGGER.warn("Not all LGWR buffers were flushed, waiting 3 seconds for Oracle to flush automatically.");
            Metronome metronome = Metronome.sleeper((Duration)Duration.ofSeconds(3L), (Clock)Clock.SYSTEM);
            try {
                metronome.pause();
            }
            catch (InterruptedException e) {
                LOGGER.warn("The LGWR buffer wait was interrupted.");
                throw e;
            }
        }
        LOGGER.trace("LGWR flush took {} to complete.", (Object)Duration.between(startTime, Instant.now()));
    }

    private void createRacNodesList() {
        for (String hostName : this.hosts) {
            try {
                RacNode node = new RacNode(hostName);
                this.racNodes.add(node);
                node.connect();
            }
            catch (Exception e) {
                LOGGER.warn("Connect to RAC node '{}' failed (will be retried): {}", (Object)hostName, (Object)e.getMessage());
            }
        }
    }

    private class RacNode {
        private final String hostName;
        private OracleConnection connection;
        private LogWriterFlushStrategy flushStrategy;

        RacNode(String hostName) {
            this.hostName = hostName;
        }

        public String getHostName() {
            return this.hostName;
        }

        public LogWriterFlushStrategy getFlushStrategy() {
            return this.flushStrategy;
        }

        public boolean isConnected() {
            try {
                return this.connection != null && this.connection.isConnected();
            }
            catch (SQLException e) {
                return false;
            }
        }

        public void connect() throws SQLException {
            String[] parts = this.parseHostName(this.hostName);
            String databaseHostName = parts[0];
            int port = Integer.parseInt(parts[1]);
            String sid = parts[2];
            Configuration.Builder jdbcConfigBuilder = (Configuration.Builder)((Configuration.Builder)RacCommitLogWriterFlushStrategy.this.jdbcConfiguration.edit().with(JdbcConfiguration.HOSTNAME, databaseHostName)).with(JdbcConfiguration.PORT, port);
            if (!Strings.isNullOrBlank((String)sid)) {
                jdbcConfigBuilder = (Configuration.Builder)jdbcConfigBuilder.with(JdbcConfiguration.DATABASE, sid);
            }
            JdbcConfiguration jdbcHostConfig = JdbcConfiguration.adapt((Configuration)jdbcConfigBuilder.build());
            this.connection = new OracleConnection(jdbcHostConfig);
            this.connection.setAutoCommit(false);
            LOGGER.info("Created flush connection to RAC node '{}'", (Object)this.hostName);
            this.flushStrategy = new CommitLogWriterFlushStrategy(RacCommitLogWriterFlushStrategy.this.connectorConfig, this.connection);
        }

        void reconnect() {
            try {
                if (this.connection == null) {
                    this.connect();
                } else {
                    this.connection.reconnect();
                    if (this.flushStrategy == null) {
                        this.flushStrategy = new CommitLogWriterFlushStrategy(RacCommitLogWriterFlushStrategy.this.connectorConfig, this.connection);
                    }
                }
                LOGGER.info("Successfully reconnected to Oracle RAC node '{}'", (Object)this.hostName);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to reconnect to RAC node '{}': {}", (Object)this.hostName, (Object)e.getMessage());
                this.close();
            }
        }

        public void close() {
            if (this.flushStrategy != null) {
                String hostName = this.flushStrategy.getHost();
                try {
                    this.flushStrategy.close();
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to close RAC flush strategy to node '{}'", (Object)hostName, (Object)e);
                    RacCommitLogWriterFlushStrategy.this.streamingMetrics.incrementWarningCount();
                }
            }
            if (this.connection != null) {
                try {
                    this.connection.close();
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to close RAC connection to node '{}'", (Object)this.hostName, (Object)e);
                }
            }
            this.flushStrategy = null;
        }

        private String[] parseHostName(String hostName) {
            String[] parts = new String[3];
            String[] colonParts = hostName.split(":");
            parts[0] = colonParts[0];
            if (colonParts[1].contains("/")) {
                int slashIndex = colonParts[1].indexOf(47);
                parts[1] = colonParts[1].substring(0, slashIndex);
                parts[2] = colonParts[1].substring(slashIndex + 1);
                return parts;
            }
            parts[1] = colonParts[1];
            parts[2] = null;
            return parts;
        }
    }
}

