/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql.connection.pgproto;

import io.debezium.connector.postgresql.PostgresStreamingChangeEventSource;
import io.debezium.connector.postgresql.PostgresType;
import io.debezium.connector.postgresql.PostgresValueConverter;
import io.debezium.connector.postgresql.TypeRegistry;
import io.debezium.connector.postgresql.UnchangedToastedReplicationMessageColumn;
import io.debezium.connector.postgresql.connection.AbstractReplicationMessageColumn;
import io.debezium.connector.postgresql.connection.ReplicationMessage;
import io.debezium.connector.postgresql.proto.PgProto;
import io.debezium.data.SpecialValueDecimal;
import io.debezium.time.Conversions;
import io.debezium.util.Strings;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.postgresql.core.BaseConnection;
import org.postgresql.geometric.PGpoint;
import org.postgresql.jdbc.PgArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PgProtoReplicationMessage
implements ReplicationMessage {
    private static final Logger LOGGER = LoggerFactory.getLogger(PgProtoReplicationMessage.class);
    private final PgProto.RowMessage rawMessage;
    private final TypeRegistry typeRegistry;

    public PgProtoReplicationMessage(PgProto.RowMessage rawMessage, TypeRegistry typeRegistry) {
        this.rawMessage = rawMessage;
        this.typeRegistry = typeRegistry;
    }

    @Override
    public ReplicationMessage.Operation getOperation() {
        switch (this.rawMessage.getOp()) {
            case INSERT: {
                return ReplicationMessage.Operation.INSERT;
            }
            case UPDATE: {
                return ReplicationMessage.Operation.UPDATE;
            }
            case DELETE: {
                return ReplicationMessage.Operation.DELETE;
            }
        }
        throw new IllegalArgumentException("Unknown operation '" + (Object)((Object)this.rawMessage.getOp()) + "' in replication stream message");
    }

    @Override
    public Instant getCommitTime() {
        return Instant.ofEpochSecond(0L, this.rawMessage.getCommitTime() * 1000L);
    }

    @Override
    public long getTransactionId() {
        return Integer.toUnsignedLong(this.rawMessage.getTransactionId());
    }

    @Override
    public String getTable() {
        return this.rawMessage.getTable();
    }

    @Override
    public List<ReplicationMessage.Column> getOldTupleList() {
        return this.transform(this.rawMessage.getOldTupleList(), null);
    }

    @Override
    public List<ReplicationMessage.Column> getNewTupleList() {
        return this.transform(this.rawMessage.getNewTupleList(), this.rawMessage.getNewTypeinfoList());
    }

    @Override
    public boolean hasTypeMetadata() {
        return this.rawMessage.getNewTypeinfoList() != null && !this.rawMessage.getNewTypeinfoList().isEmpty();
    }

    private List<ReplicationMessage.Column> transform(List<PgProto.DatumMessage> messageList, List<PgProto.TypeInfo> typeInfoList) {
        return IntStream.range(0, messageList.size()).mapToObj(index -> {
            final PgProto.DatumMessage datum = (PgProto.DatumMessage)messageList.get(index);
            Optional<Object> typeInfo = Optional.ofNullable(this.hasTypeMetadata() && typeInfoList != null ? (PgProto.TypeInfo)typeInfoList.get(index) : null);
            String columnName = Strings.unquoteIdentifierPart((String)datum.getColumnName());
            PostgresType type = this.typeRegistry.get((int)datum.getColumnType());
            if (datum.hasDatumMissing()) {
                return new UnchangedToastedReplicationMessageColumn(columnName, type, typeInfo.map(PgProto.TypeInfo::getModifier).orElse(null), typeInfo.map(PgProto.TypeInfo::getValueOptional).orElse(Boolean.FALSE), this.hasTypeMetadata());
            }
            return new AbstractReplicationMessageColumn(columnName, type, typeInfo.map(PgProto.TypeInfo::getModifier).orElse(null), typeInfo.map(PgProto.TypeInfo::getValueOptional).orElse(Boolean.FALSE), this.hasTypeMetadata()){

                @Override
                public Object getValue(PostgresStreamingChangeEventSource.PgConnectionSupplier connection, boolean includeUnknownDatatypes) {
                    return PgProtoReplicationMessage.this.getValue(datum, connection, includeUnknownDatatypes);
                }

                public String toString() {
                    return datum.toString();
                }
            };
        }).collect(Collectors.toList());
    }

    @Override
    public boolean isLastEventForLsn() {
        return true;
    }

    public Object getValue(PgProto.DatumMessage datumMessage, PostgresStreamingChangeEventSource.PgConnectionSupplier connection, boolean includeUnknownDatatypes) {
        if (datumMessage.hasDatumMissing()) {
            return UnchangedToastedReplicationMessageColumn.UNCHANGED_TOAST_VALUE;
        }
        int columnType = (int)datumMessage.getColumnType();
        switch (columnType) {
            case 16: {
                return datumMessage.hasDatumBool() ? Boolean.valueOf(datumMessage.getDatumBool()) : null;
            }
            case 21: 
            case 23: {
                return datumMessage.hasDatumInt32() ? Integer.valueOf(datumMessage.getDatumInt32()) : null;
            }
            case 20: 
            case 26: 
            case 790: {
                return datumMessage.hasDatumInt64() ? Long.valueOf(datumMessage.getDatumInt64()) : null;
            }
            case 700: {
                return datumMessage.hasDatumFloat() ? Float.valueOf(datumMessage.getDatumFloat()) : null;
            }
            case 701: {
                return datumMessage.hasDatumDouble() ? Double.valueOf(datumMessage.getDatumDouble()) : null;
            }
            case 1700: {
                if (datumMessage.hasDatumDouble()) {
                    return datumMessage.getDatumDouble();
                }
                if (datumMessage.hasDatumString()) {
                    String s = datumMessage.getDatumString();
                    return PostgresValueConverter.toSpecialValue(s).orElseGet(() -> new SpecialValueDecimal(new BigDecimal(s)));
                }
                return null;
            }
            case 18: 
            case 25: 
            case 114: 
            case 142: 
            case 650: 
            case 774: 
            case 829: 
            case 869: 
            case 1042: 
            case 1043: 
            case 1560: 
            case 1562: 
            case 2950: 
            case 3802: {
                return datumMessage.hasDatumString() ? datumMessage.getDatumString() : null;
            }
            case 1082: {
                return datumMessage.hasDatumInt32() ? Long.valueOf(datumMessage.getDatumInt32()) : null;
            }
            case 1114: {
                if (!datumMessage.hasDatumInt64()) {
                    return null;
                }
                return Conversions.toInstantFromMicros((long)datumMessage.getDatumInt64());
            }
            case 1184: {
                if (!datumMessage.hasDatumInt64()) {
                    return null;
                }
                return Conversions.toInstantFromMicros((long)datumMessage.getDatumInt64()).atOffset(ZoneOffset.UTC);
            }
            case 1083: {
                if (!datumMessage.hasDatumInt64()) {
                    return null;
                }
                return Duration.of(datumMessage.getDatumInt64(), ChronoUnit.MICROS);
            }
            case 1266: {
                if (!datumMessage.hasDatumDouble()) {
                    return null;
                }
                return Conversions.toInstantFromMicros((long)((long)datumMessage.getDatumDouble())).atOffset(ZoneOffset.UTC).toOffsetTime();
            }
            case 1186: {
                return datumMessage.hasDatumDouble() ? Double.valueOf(datumMessage.getDatumDouble()) : null;
            }
            case 17: {
                return datumMessage.hasDatumBytes() ? datumMessage.getDatumBytes().toByteArray() : null;
            }
            case 600: {
                PgProto.Point datumPoint = datumMessage.getDatumPoint();
                return new PGpoint(datumPoint.getX(), datumPoint.getY());
            }
            case 3904: 
            case 3906: 
            case 3908: 
            case 3910: 
            case 3912: 
            case 3926: {
                return datumMessage.hasDatumBytes() ? new String(datumMessage.getDatumBytes().toByteArray(), Charset.forName("UTF-8")) : null;
            }
            case 143: 
            case 199: 
            case 651: 
            case 775: 
            case 791: 
            case 1000: 
            case 1001: 
            case 1002: 
            case 1003: 
            case 1005: 
            case 1007: 
            case 1009: 
            case 1014: 
            case 1015: 
            case 1016: 
            case 1017: 
            case 1021: 
            case 1022: 
            case 1028: 
            case 1040: 
            case 1041: 
            case 1115: 
            case 1182: 
            case 1183: 
            case 1185: 
            case 1187: 
            case 1231: 
            case 1270: 
            case 1563: 
            case 2201: 
            case 2951: 
            case 3807: 
            case 3905: 
            case 3907: 
            case 3909: 
            case 3911: 
            case 3913: 
            case 3927: {
                return this.getArray(datumMessage, connection, columnType);
            }
            case 0: {
                return null;
            }
        }
        PostgresType type = this.typeRegistry.get(columnType);
        if (type.getOid() == this.typeRegistry.geometryOid() || type.getOid() == this.typeRegistry.geographyOid() || type.getOid() == this.typeRegistry.citextOid()) {
            return datumMessage.getDatumBytes().toByteArray();
        }
        if (type.getOid() == this.typeRegistry.hstoreOid()) {
            return datumMessage.getDatumBytes().toByteArray();
        }
        if (type.getOid() == this.typeRegistry.geometryArrayOid() || type.getOid() == this.typeRegistry.geographyArrayOid() || type.getOid() == this.typeRegistry.citextArrayOid() || type.getOid() == this.typeRegistry.hstoreArrayOid()) {
            return this.getArray(datumMessage, connection, columnType);
        }
        if (includeUnknownDatatypes && datumMessage.hasDatumBytes()) {
            return datumMessage.getDatumBytes().toByteArray();
        }
        return null;
    }

    private Object getArray(PgProto.DatumMessage datumMessage, PostgresStreamingChangeEventSource.PgConnectionSupplier connection, int columnType) {
        try {
            byte[] data;
            byte[] byArray = data = datumMessage.hasDatumBytes() ? datumMessage.getDatumBytes().toByteArray() : null;
            if (data == null) {
                return null;
            }
            String dataString = new String(data, Charset.forName("UTF-8"));
            PgArray arrayData = new PgArray((BaseConnection)connection.get(), columnType, dataString);
            Object deserializedArray = arrayData.getArray();
            return Arrays.asList((Object[])deserializedArray);
        }
        catch (SQLException e) {
            LOGGER.warn("Unexpected exception trying to process PgArray column '{}'", (Object)datumMessage.getColumnName(), (Object)e);
            return null;
        }
    }
}

