/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql;

import io.debezium.config.Configuration;
import io.debezium.connector.postgresql.Module;
import io.debezium.connector.postgresql.PostgresConnectorConfig;
import io.debezium.connector.postgresql.PostgresConnectorTask;
import io.debezium.connector.postgresql.connection.PostgresConnection;
import io.debezium.util.Strings;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.Config;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigValue;
import org.apache.kafka.connect.connector.Task;
import org.apache.kafka.connect.source.SourceConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresConnector
extends SourceConnector {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private Map<String, String> props;

    public String version() {
        return Module.version();
    }

    public Class<? extends Task> taskClass() {
        return PostgresConnectorTask.class;
    }

    public void start(Map<String, String> props) {
        this.props = props;
    }

    public List<Map<String, String>> taskConfigs(int maxTasks) {
        return this.props == null ? Collections.emptyList() : Collections.singletonList(new HashMap<String, String>(this.props));
    }

    public void stop() {
        this.props = null;
    }

    public ConfigDef config() {
        return PostgresConnectorConfig.configDef();
    }

    public Config validate(Map<String, String> connectorConfigs) {
        PostgresConnectorConfig config = new PostgresConnectorConfig(Configuration.from(connectorConfigs));
        Map<String, ConfigValue> results = config.validate();
        ConfigValue hostnameValue = results.get(PostgresConnectorConfig.HOSTNAME.name());
        ConfigValue portValue = results.get(PostgresConnectorConfig.PORT.name());
        ConfigValue databaseValue = results.get(PostgresConnectorConfig.DATABASE_NAME.name());
        ConfigValue userValue = results.get(PostgresConnectorConfig.USER.name());
        ConfigValue passwordValue = results.get(PostgresConnectorConfig.PASSWORD.name());
        String passwordStringValue = config.getConfig().getString(PostgresConnectorConfig.PASSWORD);
        if (Strings.isNullOrEmpty((String)passwordStringValue)) {
            this.logger.warn("The connection password is empty");
        }
        if (hostnameValue.errorMessages().isEmpty() && portValue.errorMessages().isEmpty() && userValue.errorMessages().isEmpty() && passwordValue.errorMessages().isEmpty() && databaseValue.errorMessages().isEmpty()) {
            try (PostgresConnection connection = new PostgresConnection(config.jdbcConfig());){
                try {
                    connection.execute(new String[]{"SELECT version()"});
                    this.logger.info("Successfully tested connection for {} with user '{}'", (Object)connection.connectionString(), (Object)connection.username());
                }
                catch (SQLException e) {
                    this.logger.info("Failed testing connection for {} with user '{}'", (Object)connection.connectionString(), (Object)connection.username());
                    hostnameValue.addErrorMessage("Unable to connect: " + e.getMessage());
                }
            }
        }
        return new Config(new ArrayList<ConfigValue>(results.values()));
    }
}

