/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql.connection;

import io.debezium.connector.postgresql.PostgresType;
import io.debezium.connector.postgresql.connection.ReplicationMessage;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.kafka.connect.errors.ConnectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReplicationMessageColumn
implements ReplicationMessage.Column {
    private final String columnName;
    private final String typeWithModifiers;
    private final boolean optional;
    private TypeMetadataImpl typeMetadata;
    private final boolean hasMetadata;
    private final PostgresType type;

    public AbstractReplicationMessageColumn(String columnName, PostgresType type, String typeWithModifiers, boolean optional, boolean hasMetadata) {
        this.columnName = columnName;
        this.type = type;
        this.typeWithModifiers = typeWithModifiers;
        this.optional = optional;
        this.hasMetadata = hasMetadata;
    }

    private void initMetadata() {
        assert (this.hasMetadata) : "Metadata not available";
        this.typeMetadata = new TypeMetadataImpl(this.columnName, this.type, this.typeWithModifiers, this.optional);
    }

    @Override
    public PostgresType getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.columnName;
    }

    @Override
    public boolean isOptional() {
        return this.optional;
    }

    @Override
    public TypeMetadataImpl getTypeMetadata() {
        if (this.typeMetadata == null) {
            this.initMetadata();
        }
        return this.typeMetadata;
    }

    public static class TypeMetadataImpl
    implements ReplicationMessage.ColumnTypeMetadata {
        private static final Logger LOGGER = LoggerFactory.getLogger(TypeMetadataImpl.class);
        private static final String[] NO_MODIFIERS = new String[0];
        public static final Pattern TYPE_PATTERN = Pattern.compile("^(?<schema>[^\\.\\(]+\\.)?(?<full>(?<base>[^(\\[]+)(?:\\((?<mod>.+)\\))?(?<suffix>.*?))(?<array>\\[\\])?$");
        private static final Pattern TYPEMOD_PATTERN = Pattern.compile("\\s*,\\s*");
        private Integer length;
        private Integer scale;
        private final boolean optional;

        public TypeMetadataImpl(String columnName, PostgresType type, String typeWithModifiers, boolean optional) {
            this.optional = optional;
            Matcher m = TYPE_PATTERN.matcher(typeWithModifiers);
            if (!m.matches()) {
                LOGGER.error("Failed to parse columnType for {} '{}'", (Object)columnName, (Object)typeWithModifiers);
                throw new ConnectException(String.format("Failed to parse columnType '%s' for column %s", typeWithModifiers, columnName));
            }
            String[] typeModifiers = m.group("mod") != null ? TYPEMOD_PATTERN.split(m.group("mod")) : NO_MODIFIERS;
            this.length = type.getDefaultLength();
            this.scale = type.getDefaultScale();
            if (typeModifiers.length > 0) {
                try {
                    String typMod = typeModifiers[0];
                    this.length = type.length(Integer.parseInt(typMod));
                    this.scale = type.scale(Integer.parseInt(typMod));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (typeModifiers.length > 1) {
                try {
                    this.scale = Integer.parseInt(typeModifiers[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public int getScale() {
            return this.scale;
        }

        public boolean isOptional() {
            return this.optional;
        }
    }
}

