/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql;

import io.debezium.DebeziumException;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class PgSnapshot {
    private static final String SNAPSHOT_FORMAT = "(\\d+):(\\d+):((\\d+,*)+)*";
    private static final Pattern SNAPSHOT_PATTERN = Pattern.compile("(\\d+):(\\d+):((\\d+,*)+)*");
    private static final String SEPARATOR = ",";
    private final Long xMin;
    private final Long xMax;
    private final Set<Long> xip;

    public PgSnapshot(Long xMin, Long xMax, Set<Long> xip) {
        this.xMin = xMin;
        this.xMax = xMax;
        this.xip = xip;
    }

    public Long getXMin() {
        return this.xMin;
    }

    public Long getXMax() {
        return this.xMax;
    }

    public Set<Long> getXip() {
        return this.xip;
    }

    public static PgSnapshot valueOf(String snapshotString) {
        Matcher matcher = SNAPSHOT_PATTERN.matcher(snapshotString);
        if (matcher.matches()) {
            Long xmin = Long.parseLong(matcher.group(1));
            Long xmax = Long.parseLong(matcher.group(2));
            Set<Long> xip = Set.of();
            if (matcher.group(3) != null) {
                xip = Arrays.stream(matcher.group(3).split(SEPARATOR)).map(Long::parseLong).collect(Collectors.toSet());
            }
            return new PgSnapshot(xmin, xmax, xip);
        }
        throw new DebeziumException(String.format("Unable to parse PgCurrentSnapshot result %s.", snapshotString));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PgSnapshot that = (PgSnapshot)o;
        return Objects.equals(this.xMin, that.xMin) && Objects.equals(this.xMax, that.xMax) && Objects.equals(this.xip, that.xip);
    }

    public int hashCode() {
        return Objects.hash(this.xMin, this.xMax, this.xip);
    }

    public String toString() {
        return "PgSnapshot{xMin=" + this.xMin + ", xMax=" + this.xMax + ", xip=" + String.valueOf(this.xip) + "}";
    }
}

